/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.instantmessagingserver;

import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerDefinition;
import com.atlassian.bamboo.security.EncryptionException;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.spring.ComponentAccessor;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="IMSERVER")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class InstantMessagingServerDefinitionImpl
extends BambooEntityObject
implements InstantMessagingServerDefinition {
    private static final Logger log = Logger.getLogger(InstantMessagingServerDefinitionImpl.class);
    protected String name;
    private String host;
    private Integer port;
    private String username;
    private String password;
    private String resource;
    private boolean secureConnectionRequired;
    private boolean enforceLegacySsl;

    public InstantMessagingServerDefinitionImpl() {
    }

    public InstantMessagingServerDefinitionImpl(long id, String name, String host, String username, String password, String resource, boolean enforceLegacySsl, boolean secureConnectionRequired) {
        this.setId(id);
        this.setName(name);
        this.setHost(host);
        this.setUsername(username);
        this.setPassword(password);
        this.setResource(resource);
        this.setEnforceLegacySsl(enforceLegacySsl);
        this.setSecureConnectionRequired(secureConnectionRequired);
    }

    public InstantMessagingServerDefinitionImpl(long id, String name, String host, int port, String username, String password, String resource, boolean enforceLegacySsl, boolean secureConnectionRequired) {
        this(id, name, host, (Integer)port, username, password, resource, enforceLegacySsl, secureConnectionRequired);
    }

    public InstantMessagingServerDefinitionImpl(long id, String name, String host, Integer port, String username, String password, String resource, boolean enforceLegacySsl, boolean secureConnectionRequired) {
        this(id, name, host, username, password, resource, enforceLegacySsl, secureConnectionRequired);
        this.setPort(port);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.getEncryptedPassword())) {
                return ((EncryptionService)ComponentAccessor.ENCRYPTION_SERVICE.get()).decrypt(this.getEncryptedPassword());
            }
        }
        catch (EncryptionException e) {
            log.warn((Object)"Could not decrypt password.", (Throwable)e);
        }
        return null;
    }

    public void setPassword(String password) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)password)) {
                this.setEncryptedPassword(((EncryptionService)ComponentAccessor.ENCRYPTION_SERVICE.get()).encrypt(password));
            } else {
                this.setEncryptedPassword(null);
            }
        }
        catch (EncryptionException e) {
            log.error((Object)"Could not encrypt passord", (Throwable)e);
            this.setEncryptedPassword(null);
        }
    }

    public String getEncryptedPassword() {
        return this.password;
    }

    public void setEncryptedPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isEnforceLegacySsl() {
        return this.enforceLegacySsl;
    }

    public void setEnforceLegacySsl(boolean enforceLegacySsl) {
        this.enforceLegacySsl = enforceLegacySsl;
    }

    public boolean isSecureConnectionRequired() {
        return this.secureConnectionRequired;
    }

    public void setSecureConnectionRequired(boolean secureConnectionRequired) {
        this.secureConnectionRequired = secureConnectionRequired;
    }

    public String toString() {
        return "InstantMessagingServerDefinitionImpl{name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", username='" + this.username + '\'' + ", resource='" + this.resource + '\'' + ", secureConnectionRequired=" + this.secureConnectionRequired + ", enforceLegacySsl=" + this.enforceLegacySsl + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof InstantMessagingServerDefinitionImpl)) {
            return false;
        }
        InstantMessagingServerDefinitionImpl rhs = (InstantMessagingServerDefinitionImpl)((Object)o);
        return new EqualsBuilder().append(this.getId(), rhs.getId()).isEquals();
    }

    public int compareTo(Object obj) {
        InstantMessagingServerDefinitionImpl o = (InstantMessagingServerDefinitionImpl)((Object)obj);
        return new CompareToBuilder().append((Object)this.getName(), (Object)o.getName()).append(this.getId(), o.getId()).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder(1523, 79).append(this.getId()).toHashCode();
    }
}

