/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.instantmessagingserver;

import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerDao;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerDefinition;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerManager;
import com.atlassian.core.bean.EntityObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class InstantMessagingServerManagerImpl
implements InstantMessagingServerManager {
    private static final Logger log = Logger.getLogger(InstantMessagingServerManagerImpl.class);
    private InstantMessagingServerDao instantMessagingServerDao;

    @NotNull
    public Collection<InstantMessagingServerDefinition> getAllInstantMessagingServers() {
        List instantMessagingServers = this.instantMessagingServerDao.findAll();
        if (instantMessagingServers == null) {
            instantMessagingServers = Collections.emptyList();
        }
        return Collections.unmodifiableCollection(instantMessagingServers);
    }

    public void saveInstantMessagingServer(InstantMessagingServerDefinition instantMessagingServer) {
        if (!(instantMessagingServer instanceof EntityObject)) {
            throw new IllegalArgumentException("Cannot save a null Instant Messaging Server definition");
        }
        this.instantMessagingServerDao.save((EntityObject)instantMessagingServer);
    }

    public InstantMessagingServerDefinition getInstantMessagingServer(long instantMessagingServerId) {
        return (InstantMessagingServerDefinition)this.instantMessagingServerDao.findById(instantMessagingServerId);
    }

    public void removeInstantMessagingServer(long instantMessagingServerId) {
        InstantMessagingServerDefinition instantMessagingServer = this.getInstantMessagingServer(instantMessagingServerId);
        if (!(instantMessagingServer instanceof EntityObject)) {
            throw new IllegalArgumentException("Cannot remove a IM Server. IM Server with id " + instantMessagingServerId + " does not exist");
        }
        this.instantMessagingServerDao.remove((EntityObject)instantMessagingServer);
    }

    public void setInstantMessagingServerDao(InstantMessagingServerDao instantMessagingServerDao) {
        this.instantMessagingServerDao = instantMessagingServerDao;
    }
}

