/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.issuelink;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.applinks.ImpersonationService;
import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.jira.issuelink.JiraBranchLinkingService;
import com.atlassian.bamboo.jira.issuelink.RemoteLinkCreationFailedException;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueHelper;
import com.atlassian.bamboo.jira.jiraissues.JiraIssuePredicates;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.jira.jiraissues.JiraRemoteIssueManager;
import com.atlassian.bamboo.jira.rest.JiraRestResponse;
import com.atlassian.bamboo.jira.rest.JiraRestService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraBranchLinkingServiceImpl
implements JiraBranchLinkingService {
    private static final Logger log = Logger.getLogger(JiraBranchLinkingServiceImpl.class);
    private final PlanManager planManager;
    private final JiraRemoteIssueManager jiraRemoteIssueManager;
    private final JiraRestService jiraRestService;
    private final JiraApplinksService jiraApplinksService;
    private final JiraIssueHelper jiraIssueUtils;
    private final ImpersonationService impersonationService;
    private final ThreadFactory threadFactory;
    private final ImmutablePlanCacheService immutablePlanCacheService;

    public JiraBranchLinkingServiceImpl(PlanManager planManager, JiraRemoteIssueManager jiraRemoteIssueManager, JiraRestService jiraRestService, JiraApplinksService jiraApplinksService, JiraIssueUtils jiraIssueUtils, ImpersonationService impersonationService, ImmutablePlanCacheService immutablePlanCacheService) {
        this.planManager = planManager;
        this.jiraRemoteIssueManager = jiraRemoteIssueManager;
        this.jiraRestService = jiraRestService;
        this.jiraApplinksService = jiraApplinksService;
        this.jiraIssueUtils = jiraIssueUtils;
        this.impersonationService = impersonationService;
        this.immutablePlanCacheService = immutablePlanCacheService;
        this.threadFactory = new SystemAuthorityThreadFactory("BranchJiraLinkingBackgroundThread");
    }

    public void linkBranchToIssueIfRequiredAsync(@NotNull PlanKey planKey, @Nullable String username) {
        this.threadFactory.newThread(() -> this.linkBranchToIssue(planKey, username)).start();
    }

    private synchronized void linkBranchToIssue(@NotNull PlanKey planKey, @Nullable String username) {
        log.debug((Object)("Detecting linked Jira issues for branch '" + planKey + "'"));
        ImmutableChain chain = this.immutablePlanCacheService.getImmutablePlanByKey(planKey);
        if (chain == null) {
            log.debug((Object)("Could not link branch to Jira issue. Plan with key " + planKey + " could not be found"));
            return;
        }
        ImmutableChainBranch branch = (ImmutableChainBranch)Narrow.to((Object)chain, ImmutableChainBranch.class);
        if (branch == null) {
            log.debug((Object)("Could not link branch to Jira issue. Plan with key " + planKey + " is not a branch"));
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)branch.getLinkedJiraIssue()) && !branch.isRemoteJiraLinkRequired()) {
            log.debug((Object)("Did not link branch to Jira issue. Plan with key " + planKey + " is already successfully linked to issue " + branch.getLinkedJiraIssue()));
            return;
        }
        if (!this.jiraApplinksService.hasJiraApplicationLink()) {
            log.debug((Object)"Did not link branch to issue. No Jira application links were found.");
            return;
        }
        String issueKey = this.findIssueKeyToLink(branch);
        if (StringUtils.isNotBlank((CharSequence)issueKey)) {
            log.debug((Object)("Found issue key '" + issueKey + "'"));
            JiraIssueDetails details = null;
            try {
                ImmutableChain master = branch.getMaster();
                if (master != null && master.getBuildDefinition().getBranchMonitoringConfiguration().isRemoteJiraBranchLinkingEnabled()) {
                    Callable jiraIssueDetailsCallable = this.impersonationService.runWithOptionalUserImpersonation(username, () -> this.createRemoteLinkToBranch(branch, issueKey));
                    details = (JiraIssueDetails)jiraIssueDetailsCallable.call();
                } else {
                    log.debug((Object)"Did not create remote link in Jira.  Remote linking is disabled.");
                }
            }
            catch (CredentialsRequiredContextException e) {
                log.warn((Object)("Could not link issue '" + issueKey + "' to branch '" + branch.getName() + "'. Authentication required for user " + username));
            }
            catch (RemoteLinkCreationFailedException e) {
                log.warn((Object)e.getMessage());
                if (e.getResponse() != null && e.getResponse().hasErrors()) {
                    log.warn((Object)e.getResponse().errors);
                }
            }
            catch (Exception e) {
                log.error((Object)("An unexpected error occurred while creating remote jira link: " + e.getMessage()), (Throwable)e);
            }
            ChainBranch mutableBranch = (ChainBranch)this.planManager.getPlanByKey(branch.getPlanKey(), ChainBranch.class);
            if (mutableBranch != null) {
                if (StringUtils.isNotBlank((CharSequence)issueKey)) {
                    mutableBranch.setLinkedJiraIssue(issueKey);
                    mutableBranch.setRemoteJiraLinkRequired(details == null);
                }
                if (details != null && StringUtils.isNotBlank((CharSequence)details.getSummary())) {
                    mutableBranch.setDescription(details.getSummary());
                }
                this.planManager.savePlan((Plan)mutableBranch);
            } else {
                throw new IllegalStateException("Could not complete branch/issue linking operations.  Branch disappeared half way through the operation...");
            }
        }
    }

    @NotNull
    public JiraIssueDetails createRemoteLinkToBranch(@NotNull ImmutableChainBranch branch, @NotNull String issueKey) throws RemoteLinkCreationFailedException, CredentialsRequiredContextException {
        log.debug((Object)("Creating remote link from issue '" + issueKey + "' to branch '" + branch.getName() + "'"));
        try {
            String projectKey = JiraIssuePredicates.getJiraProjectKey(issueKey);
            ApplicationLink jiraApplicationLink = this.jiraRemoteIssueManager.getJiraApplicationLink(projectKey, branch.getProject());
            if (jiraApplicationLink != null) {
                JiraIssueDetails issue = this.getJiraIssueForLinking(jiraApplicationLink, issueKey, projectKey, branch);
                if (issue != null) {
                    JSONObject remoteIssueLinkJson = this.jiraRestService.getRemoteIssueLinkJson("planKey=" + branch.getPlanKey().getKey(), this.getPlanName((ImmutablePlan)branch), branch.getPlanKey().getKey(), "Bamboo Branches", "/browse/" + branch.getPlanKey().getKey() + "/latest", jiraApplicationLink.getRpcUrl() + "/download/resources/com.atlassian.jira.plugin.ext.bamboo:bamboo-version-tabpanel/images/icon_bamboo.png");
                    JiraRestResponse response = this.jiraRestService.doRestCallViaApplink(jiraApplicationLink, "rest/api/latest/issue/" + issue.getIssueKey() + "/remotelink", Request.MethodType.POST, remoteIssueLinkJson);
                    if (response.hasErrors()) {
                        throw new RemoteLinkCreationFailedException("Failed to link jira issue " + issue.getIssueKey() + " (" + jiraApplicationLink.getName() + ") to plan branch " + branch.getName(), response);
                    }
                    log.debug((Object)"Remote link created successfully.");
                    return issue;
                }
                throw new RemoteLinkCreationFailedException(this.getRemoteLinkFailedMessage(issueKey, branch.getName(), "No issue with key " + issueKey + " could be found."));
            }
            throw new RemoteLinkCreationFailedException(this.getRemoteLinkFailedMessage(issueKey, branch.getName(), "No matching Jira project could be found on any linked Jira Server."));
        }
        catch (ResponseException | JSONException e) {
            throw new RemoteLinkCreationFailedException(this.getRemoteLinkFailedMessage(issueKey, branch.getName(), e.getMessage()), e);
        }
    }

    @Nullable
    public String findIssueKeyToLink(@NotNull ImmutableChainBranch branch) {
        String planBranchName = branch.getBuildName();
        log.debug((Object)("Checking plan branch name [" + planBranchName + "] for issue keys"));
        Iterable<String> issueKeys = this.findIssueKeys(planBranchName);
        String issueKey = (String)Iterables.getFirst(issueKeys, null);
        if (issueKey != null) {
            return issueKey;
        }
        PlanRepositoryDefinition repositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)branch);
        if (repositoryDefinition != null && repositoryDefinition.getBranch() != null) {
            String vcsBranchName = repositoryDefinition.getBranch().getVcsBranch().getName();
            log.debug((Object)("Checking VCS branch name [" + vcsBranchName + "] for issue keys"));
            return (String)Iterables.getFirst(this.findIssueKeys(vcsBranchName), null);
        }
        return null;
    }

    @NotNull
    private Iterable<String> findIssueKeys(String planBranchName) {
        return this.jiraIssueUtils.findPotentialIssueKeys(planBranchName, false, JiraIssueUtils.LENIENT_ISSUE_KEY_BOUNDARY_REGEX, JiraIssueUtils.LENIENT_ISSUE_KEY_BOUNDARY_REGEX);
    }

    @NotNull
    private String getPlanName(ImmutablePlan plan) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringEscapeUtils.escapeHtml4((String)plan.getProject().getName())).append(" \u203a ");
        ImmutablePlan master = plan.getMaster();
        if (master != null) {
            builder.append(StringEscapeUtils.escapeHtml4((String)master.getBuildName())).append(" \u203a ");
        }
        builder.append(StringEscapeUtils.escapeHtml4((String)plan.getBuildName()));
        return builder.toString();
    }

    private JiraIssueDetails getJiraIssueForLinking(@NotNull ApplicationLink jiraApplicationLink, @NotNull String issueKey, @NotNull String projectKey, @NotNull ImmutableChainBranch branch) throws CredentialsRequiredContextException, RemoteLinkCreationFailedException {
        Result result = this.jiraRemoteIssueManager.fetchIssueDetailsFromJira(jiraApplicationLink, projectKey, (Set)Sets.newHashSet((Object[])new String[]{issueKey}));
        if (!result.hasException()) {
            List issues = (List)result.getResult();
            if (issues == null || issues.isEmpty()) {
                throw new RemoteLinkCreationFailedException(this.getRemoteLinkFailedMessage(issueKey, branch.getName(), "No issue with this key could be found."));
            }
            if (issues.size() > 1) {
                throw new RemoteLinkCreationFailedException(this.getRemoteLinkFailedMessage(issueKey, branch.getName(), "Multiple matching issues with this key were found."));
            }
            return (JiraIssueDetails)issues.get(0);
        }
        throw new CredentialsRequiredContextException(jiraApplicationLink.getName(), (CredentialsRequiredException)result.getException());
    }

    private String getRemoteLinkFailedMessage(String issueKey, String branchName, String error) {
        return "Could not create remote issue link from issue '" + issueKey + "' to plan branch '" + branchName + "'. " + error;
    }
}

