/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.jiraissues;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetailsBuilder;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetailsImpl;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.jira.jirametadata.JiraAssignee;
import com.atlassian.bamboo.jira.jirametadata.JiraStatus;
import com.atlassian.bamboo.jira.jirametadata.JiraType;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JiraIssueDetailsBuilderImpl
implements JiraIssueDetailsBuilder {
    private static final Logger log = Logger.getLogger(JiraIssueDetailsBuilderImpl.class);
    private String issueKey;
    private String summary;
    private JiraType type;
    private JiraStatus status;
    private URL displayUrl;
    private JiraAssignee assignee;
    private Collection<String> fixVersions;
    private ApplicationLink applicationLink;

    public JiraIssueDetailsBuilderImpl issueKey(@NotNull String issueKey) {
        this.issueKey = issueKey;
        return this;
    }

    public JiraIssueDetailsBuilderImpl summary(@NotNull String summary) {
        this.summary = summary;
        return this;
    }

    public JiraIssueDetailsBuilderImpl type(@NotNull JiraType type) {
        this.type = type;
        return this;
    }

    public JiraIssueDetailsBuilderImpl status(@NotNull JiraStatus status) {
        this.status = status;
        return this;
    }

    public JiraIssueDetailsBuilder displayUrl(@NotNull ApplicationLink applicationLink) {
        this.applicationLink = applicationLink;
        return this;
    }

    public JiraIssueDetailsBuilder displayUrl(@NotNull EntityLink entityLink) {
        return this.displayUrl(entityLink.getApplicationLink());
    }

    public JiraIssueDetailsBuilder displayUrl(@NotNull String url) {
        try {
            return this.displayUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            log.error((Object)"Malformed issue URL", (Throwable)e);
            return this;
        }
    }

    public JiraIssueDetailsBuilder displayUrl(@NotNull URL url) {
        this.displayUrl = url;
        return this;
    }

    public JiraIssueDetailsBuilderImpl assignee(@NotNull JiraAssignee assignee) {
        this.assignee = assignee;
        return this;
    }

    public JiraIssueDetailsBuilderImpl fixVersions(@NotNull Collection<String> fixVersions) {
        this.fixVersions = fixVersions;
        return this;
    }

    public JiraIssueDetails build() {
        this.issueKey = (String)Preconditions.checkNotNull((Object)this.issueKey);
        JiraIssueDetailsImpl result = new JiraIssueDetailsImpl();
        result.setIssueKey(this.issueKey);
        result.setSummary(this.summary);
        result.setType(this.type);
        result.setStatus(this.status);
        result.setAssignee(this.assignee);
        result.setFixVersions(this.fixVersions);
        if (this.applicationLink != null && this.displayUrl == null) {
            String jiraUrl = JiraIssueUtils.getJiraDisplayUrl(this.applicationLink, this.issueKey);
            assert (jiraUrl != null);
            this.displayUrl(jiraUrl);
        }
        if (this.displayUrl != null) {
            result.setDisplayUrl(this.displayUrl);
        }
        return result;
    }
}

