/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.jiraissues;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.jira.jiraissues.InternalLinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetailsBuilderFactory;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueManager;
import com.atlassian.bamboo.jira.jiraissues.JiraIssuePredicates;
import com.atlassian.bamboo.jira.jiraissues.JiraRemoteIssueManager;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraIssueManagerImpl
implements JiraIssueManager {
    private static final Logger log = Logger.getLogger(JiraIssueManagerImpl.class);
    private final JiraApplinksService jiraApplinksService;
    private final JiraIssueDetailsBuilderFactory jiraIssueDetailsBuilderFactory;
    private final JiraRemoteIssueManager jiraRemoteIssueManager;

    public JiraIssueManagerImpl(JiraApplinksService jiraApplinksService, JiraIssueDetailsBuilderFactory jiraIssueDetailsBuilderFactory, JiraRemoteIssueManager jiraRemoteIssueManager) {
        this.jiraApplinksService = jiraApplinksService;
        this.jiraIssueDetailsBuilderFactory = jiraIssueDetailsBuilderFactory;
        this.jiraRemoteIssueManager = jiraRemoteIssueManager;
    }

    @NotNull
    public <T extends InternalLinkedJiraIssue> Iterable<T> getJiraIssueDetails(@Nullable Project bambooProject, @NotNull Iterable<T> linkedJiraIssues) throws CredentialsRequiredContextException, ResponseException {
        ImmutableListMultimap keyToIssueMap = Multimaps.index(linkedJiraIssues, InternalLinkedJiraIssue::getIssueKey);
        Map<String, JiraIssueDetails> keyToIssueDetailsMap = this.createJiraIssueDetails(bambooProject, keyToIssueMap.keySet());
        return Iterables.transform((Iterable)keyToIssueMap.values(), input -> {
            InternalLinkedJiraIssue jiraIssue = (InternalLinkedJiraIssue)Preconditions.checkNotNull((Object)input);
            jiraIssue.setJiraIssueDetails((JiraIssueDetails)keyToIssueDetailsMap.get(jiraIssue.getIssueKey()));
            return jiraIssue;
        });
    }

    @NotNull
    public JiraIssueDetails getJiraIssueDetails(@Nullable Project bambooProject, @NotNull String issueKey) throws CredentialsRequiredContextException, ResponseException {
        Map<String, JiraIssueDetails> keyToIssueDetailsMap = this.createJiraIssueDetails(bambooProject, Sets.newHashSet((Object[])new String[]{issueKey}));
        return keyToIssueDetailsMap.get(issueKey);
    }

    @NotNull
    protected Map<String, JiraIssueDetails> createJiraIssueDetails(@Nullable Project bambooProject, @NotNull Set<String> issueKeys) throws CredentialsRequiredContextException, ResponseException {
        LinkedHashMap minimalJiraIssueDetails = (LinkedHashMap)issueKeys.stream().map(issueKey -> this.jiraIssueDetailsBuilderFactory.builder().issueKey(issueKey).build()).collect(BambooCollectors.toMap(JiraIssueDetails::getIssueKey, LinkedHashMap::new));
        HashMultimap projectToIssueMap = (HashMultimap)issueKeys.stream().collect(BambooCollectors.toMultimap(JiraIssuePredicates::getJiraProjectKey, HashMultimap::create));
        log.debug((Object)("Resolving issues " + projectToIssueMap.values() + " from Jira projects " + projectToIssueMap.keySet()));
        LinkedHashMap<String, Result<CredentialsRequiredException, List<JiraIssueDetails>>> fetchedResults = new LinkedHashMap<String, Result<CredentialsRequiredException, List<JiraIssueDetails>>>();
        if (bambooProject != null) {
            fetchedResults.putAll(this.resolveWithEntityLinks(bambooProject, (SetMultimap<String, String>)projectToIssueMap));
        }
        if (!projectToIssueMap.isEmpty()) {
            Map<String, ApplicationLink> projectToApplinkMap = this.mapProjectsToApplinks(projectToIssueMap.keySet());
            for (String jiraProjectKey : projectToIssueMap.keySet()) {
                if (projectToApplinkMap.containsKey(jiraProjectKey)) {
                    ApplicationLink applicationLink = projectToApplinkMap.get(jiraProjectKey);
                    fetchedResults.put(jiraProjectKey, (Result<CredentialsRequiredException, List<JiraIssueDetails>>)this.jiraRemoteIssueManager.fetchIssueDetailsFromJira(applicationLink, jiraProjectKey, projectToIssueMap.get((Object)jiraProjectKey)));
                    continue;
                }
                log.info((Object)String.format("Cannot find Jira instance with Jira project [%s] through Bamboo application links", jiraProjectKey));
            }
        }
        return this.combineWithFetchedInformation(minimalJiraIssueDetails, fetchedResults);
    }

    private Map<String, JiraIssueDetails> combineWithFetchedInformation(Map<String, JiraIssueDetails> minimalJiraIssueDetails, Map<String, Result<CredentialsRequiredException, List<JiraIssueDetails>>> fetchedResults) throws CredentialsRequiredContextException {
        LinkedHashMap<String, JiraIssueDetails> improvedIssueDetails = new LinkedHashMap<String, JiraIssueDetails>(minimalJiraIssueDetails);
        for (Map.Entry<String, Result<CredentialsRequiredException, List<JiraIssueDetails>>> fetchedEntry : fetchedResults.entrySet()) {
            Result<CredentialsRequiredException, List<JiraIssueDetails>> fetchedResult = fetchedEntry.getValue();
            if (fetchedResult.hasException()) {
                throw new CredentialsRequiredContextException(fetchedEntry.getKey(), (CredentialsRequiredException)fetchedResult.getException());
            }
            for (JiraIssueDetails issueDetails : (List)fetchedResult.getResult()) {
                improvedIssueDetails.put(issueDetails.getIssueKey(), issueDetails);
            }
        }
        return improvedIssueDetails;
    }

    @NotNull
    private Map<String, ApplicationLink> mapProjectsToApplinks(Collection<String> jiraProjectKeys) throws CredentialsRequiredContextException {
        LinkedHashMap<String, ApplicationLink> projectToApplinkMap = new LinkedHashMap<String, ApplicationLink>();
        for (ApplicationLink applicationLink : this.jiraApplinksService.getJiraApplicationLinks()) {
            try {
                for (EntityReference entityReference : this.jiraRemoteIssueManager.fetchProjectInformationFromJira(applicationLink)) {
                    String jiraProjectKey = entityReference.getKey();
                    if (projectToApplinkMap.putIfAbsent(jiraProjectKey, applicationLink) != null) continue;
                    log.debug((Object)("Resolved issues from " + jiraProjectKey + " using an application link " + applicationLink));
                    if (!projectToApplinkMap.keySet().containsAll(jiraProjectKeys)) continue;
                    return projectToApplinkMap;
                }
            }
            catch (ResponseException responseException) {
            }
        }
        return projectToApplinkMap;
    }

    private Map<String, Result<CredentialsRequiredException, List<JiraIssueDetails>>> resolveWithEntityLinks(@NotNull Project bambooProject, SetMultimap<String, String> jiraProjectToIssueMap) {
        log.debug((Object)"Resolving issues using entity links...");
        LinkedHashMap<String, Result<CredentialsRequiredException, List<JiraIssueDetails>>> fetchedResults = new LinkedHashMap<String, Result<CredentialsRequiredException, List<JiraIssueDetails>>>();
        for (EntityLink entityLink : this.jiraApplinksService.getJiraEntityLinksForProject(bambooProject)) {
            Set jiraIssueKeys;
            String jiraProjectKey = entityLink.getKey();
            log.debug((Object)("Resolving issues using entity link: " + entityLink));
            if (!jiraProjectToIssueMap.containsKey((Object)jiraProjectKey)) continue;
            ApplicationLink applicationLink = entityLink.getApplicationLink();
            Result result = this.jiraRemoteIssueManager.fetchIssueDetailsFromJira(applicationLink, jiraProjectKey, jiraIssueKeys = jiraProjectToIssueMap.get((Object)jiraProjectKey));
            if (!result.hasException()) {
                jiraProjectToIssueMap.removeAll((Object)jiraProjectKey);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved issues from " + jiraProjectKey + " using an entity link " + entityLink));
                    log.debug((Object)("Issues: " + result.getResult()));
                }
            }
            fetchedResults.put(jiraProjectKey, (Result<CredentialsRequiredException, List<JiraIssueDetails>>)result);
        }
        return fetchedResults;
    }
}

