/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.jiraissues;

import com.atlassian.bamboo.jira.jiraissues.InternalLinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class JiraIssuePredicates {
    private static final EnumSet<JiraIssueLinkType> LINK_TYPES_RELATED = EnumSet.of(JiraIssueLinkType.BUILD_RELATES, JiraIssueLinkType.BUILD_CAUSES);

    @Deprecated
    public static JiraIssueLinkType getLinkedJiraIssueType(InternalLinkedJiraIssue linkedJiraIssue) {
        return linkedJiraIssue.getIssueType();
    }

    @Deprecated
    public static String getJiraIssueDetailsKey(JiraIssueDetails jiraIssueDetails) {
        return jiraIssueDetails.getIssueKey();
    }

    @Deprecated
    public static String getLinkedJiraIssueKey(InternalLinkedJiraIssue linkedJiraIssue) {
        return linkedJiraIssue.getIssueKey();
    }

    @NotNull
    public static String getJiraProjectKey(String jiraIssueKey) {
        int index = ((String)Preconditions.checkNotNull((Object)jiraIssueKey)).indexOf("-");
        Preconditions.checkArgument((index > 0 ? 1 : 0) != 0, (String)"%s is not a valid Jira issue key", (Object[])new Object[]{jiraIssueKey});
        return ((String)Preconditions.checkNotNull((Object)jiraIssueKey)).substring(0, index);
    }

    public static boolean isIssueFixed(InternalLinkedJiraIssue linkedJiraIssue) {
        return JiraIssueLinkType.BUILD_FIXES == linkedJiraIssue.getIssueType();
    }

    public static boolean isIssueRelated(InternalLinkedJiraIssue linkedJiraIssue) {
        return LINK_TYPES_RELATED.contains(linkedJiraIssue.getIssueType());
    }
}

