/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.jiraissues;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.deployments.versions.DeploymentVersion;
import com.atlassian.bamboo.deployments.versions.service.DeploymentVersionLinkedJiraIssuesService;
import com.atlassian.bamboo.event.ResultsSummaryUpdatedEvent;
import com.atlassian.bamboo.jira.jiraissues.InternalLinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetailsBuilderFactory;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueHelper;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueKey;
import com.atlassian.bamboo.jira.jiraissues.JiraIssuePredicates;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueComparator;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.jira.jiraissues.xml.JiraXmlSearchResultItemEntity;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraIssueUtils
implements JiraIssueHelper {
    private static final Logger log = Logger.getLogger(JiraIssueUtils.class);
    private static final String ISSUE_KEY_REGEX_STRING = "[A-Z][A-Z0-9]+-[0-9]+";
    private static final Pattern ISSUE_KEY_WITH_CONTEXT = Pattern.compile("(.??)([A-Z][A-Z0-9]+-[0-9]+)(.?)");
    public static final Pattern RESTRICTIVE_ISSUE_KEY_BOUNDARY_REGEX = Pattern.compile("[^a-zA-Z0-9-]");
    public static final Pattern LENIENT_ISSUE_KEY_BOUNDARY_REGEX = Pattern.compile("[^a-zA-Z0-9]");
    private static final Pattern ISSUE_KEY_REGEX = Pattern.compile("[A-Z][A-Z0-9]+-[0-9]+");
    private static final String REPLACE_KEY_REGEX_START = "(?<![a-zA-Z0-9\\-])";
    private static final String REPLACE_KEY_REGEX_END = "(?![a-zA-Z0-9\\-])";
    public static final String PROJECT_ISSUE_NUMBER_SEPARATOR = "-";
    public static final String RENDERED_JIRA_KEY = "<a title=\"%s\" class=\"jiraIssueLink\" data-issue-key=\"%s\" %s id=\"viewIssueInJira:%s\" href=\"%s\">%s</a>";
    public static final String RENDERED_JIRA_KEY_NO_SERVER = "<span class=\"jiraIssueLink\" data-issue-key=\"%s\" %s >%s</span>";
    private JiraApplinksService jiraApplinksService;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private ResultsSummaryManager resultsSummaryManager;
    private EventPublisher eventPublisher;
    @Inject
    private DeploymentVersionLinkedJiraIssuesService deploymentVersionLinkedJiraIssuesService;

    public JiraIssueUtils(JiraApplinksService jiraApplinksService, ResultsSummaryManager resultsSummaryManager, EventPublisher eventPublisher, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.jiraApplinksService = jiraApplinksService;
        this.resultsSummaryManager = resultsSummaryManager;
        this.eventPublisher = eventPublisher;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    JiraIssueUtils() {
    }

    public static JiraIssueUtils getFreemarkerInstance() {
        return new JiraIssueUtils();
    }

    public void findAndSaveJiraIssueKeys(@NotNull String string, @NotNull ResultsSummary buildResultsSummary) {
        Set<String> keys = this.findIssueKeysInText(string);
        for (String key : keys) {
            LinkedJiraIssueImpl issue = new LinkedJiraIssueImpl(key);
            issue.setResultsSummary(buildResultsSummary);
            buildResultsSummary.getJiraIssues().add(issue);
        }
        if (this.resultsSummaryManager != null) {
            this.resultsSummaryManager.saveResultSummary(buildResultsSummary);
            this.eventPublisher.publish((Object)new ResultsSummaryUpdatedEvent(this, buildResultsSummary.getPlanResultKey(), Sets.newHashSet(keys)));
        } else {
            log.warn((Object)("Build Results Summary Manager was null, could not save Build Result Summary " + buildResultsSummary.getPlanResultKey()));
        }
    }

    @Override
    public boolean isValidIssueKey(@NotNull String string) {
        return ISSUE_KEY_REGEX.matcher(string).matches();
    }

    @NotNull
    public Set<LinkedJiraIssue> getFixedJiraIssues(@NotNull Iterable<LinkedJiraIssue> allIssues) {
        return BambooIterables.stream(allIssues).filter(JiraIssuePredicates::isIssueFixed).collect(Collectors.toSet());
    }

    @NotNull
    public Set<LinkedJiraIssue> getRelatedJiraIssues(@NotNull Iterable<LinkedJiraIssue> allIssues) {
        return BambooIterables.stream(allIssues).filter(JiraIssuePredicates::isIssueRelated).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Set<String> findIssueKeysInText(@NotNull String string) {
        return this.findIssueKeysInText(string, false);
    }

    @Override
    @NotNull
    public Set<String> findIssueKeysInText(@NotNull String string, boolean ignoreIfInUrl) {
        return this.findPotentialIssueKeys(string, ignoreIfInUrl, RESTRICTIVE_ISSUE_KEY_BOUNDARY_REGEX, RESTRICTIVE_ISSUE_KEY_BOUNDARY_REGEX);
    }

    @Deprecated
    @NotNull
    public LinkedHashSet<String> findIssueKeys(String string, boolean ignoreIfInUrl, Pattern issueKeyBoundaryRegex) {
        return this.findPotentialIssueKeys(string, ignoreIfInUrl, issueKeyBoundaryRegex, issueKeyBoundaryRegex);
    }

    @Override
    @NotNull
    public LinkedHashSet<String> findPotentialIssueKeys(String string, boolean ignoreIfInUrl, Pattern issueKeyLeftBoundaryRegex, Pattern issueKeyRightBoundaryRegex) {
        Matcher issueKeyWithContextMatcher = ISSUE_KEY_WITH_CONTEXT.matcher(string);
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        while (issueKeyWithContextMatcher.find()) {
            int startIndex = issueKeyWithContextMatcher.start();
            if (ignoreIfInUrl && this.isPartOfUrl(string, startIndex)) continue;
            String prefix = issueKeyWithContextMatcher.group(1);
            String suffix = issueKeyWithContextMatcher.group(3);
            if (!JiraIssueUtils.isValidBoundary(prefix, issueKeyLeftBoundaryRegex) || !JiraIssueUtils.isValidBoundary(suffix, issueKeyRightBoundaryRegex)) continue;
            results.add(issueKeyWithContextMatcher.group(2));
        }
        return results;
    }

    @Override
    @NotNull
    public List<String> findIssueKeysInTextAsList(@NotNull String string, boolean ignoreIfInUrl) {
        return this.findIssueKeysInTextAsList(string, ignoreIfInUrl, RESTRICTIVE_ISSUE_KEY_BOUNDARY_REGEX);
    }

    @Override
    @NotNull
    public List<String> findIssueKeysInTextAsList(@NotNull String string, boolean ignoreIfInUrl, @NotNull Pattern issueKeyBoundaryRegex) {
        return new LinkedList<String>(this.findPotentialIssueKeys(string, ignoreIfInUrl, issueKeyBoundaryRegex, issueKeyBoundaryRegex));
    }

    private static boolean isValidBoundary(String boundary, Pattern issueKeyBoundaryRegex) {
        return boundary.isEmpty() || issueKeyBoundaryRegex.matcher(boundary).matches();
    }

    private boolean isPartOfUrl(String body, int start) {
        for (int i = start; i > 2; --i) {
            String s;
            if (body.charAt(i) == ' ') {
                return false;
            }
            if (body.charAt(i) != '/' || !(s = body.substring(i - 2, i)).equals(":/")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getRenderedString(@Nullable String inputString, @NotNull String buildKey, @NotNull Integer buildNumber) {
        ResultsSummary brs = this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((String)buildKey, (int)buildNumber), ResultsSummary.class);
        if (brs != null) {
            return this.getRenderedString(inputString, (ImmutableResultsSummary)brs);
        }
        return this.getRenderedString(inputString);
    }

    @Nullable
    public String getRenderedString(@Nullable String inputString, @NotNull ImmutableResultsSummary resultsSummary) {
        Set issueKeys = resultsSummary.getJiraIssueKeys();
        try {
            return this.getRenderedStringInternal(inputString, issueKeys, resultsSummary.getImmutablePlan().getProject().getKey());
        }
        catch (Exception e) {
            return inputString;
        }
    }

    @Nullable
    public String getRenderedString(@Nullable String inputString, @NotNull DeploymentVersion deploymentVersion) {
        return this.getRenderedStringInternal(inputString, this.deploymentVersionLinkedJiraIssuesService.getJiraIssueKeysForDeploymentVersion(deploymentVersion.getId()), null);
    }

    @Nullable
    public String getRenderedString(@Nullable String inputString) {
        return this.getRenderedStringInternal(inputString, null, null);
    }

    @Nullable
    String getRenderedStringInternal(@Nullable String inputString, @Nullable Set<String> validIssueKeys, @Nullable String bambooProjectKey) {
        if (StringUtils.isBlank((CharSequence)inputString)) {
            return inputString;
        }
        assert (inputString != null);
        Set<String> potentialKeysInComment = this.findIssueKeysInText(inputString, true);
        String renderedString = inputString;
        for (String jiraIssueKey : potentialKeysInComment) {
            if (validIssueKeys != null && !validIssueKeys.contains(jiraIssueKey)) continue;
            String bambooProjectKeyAttr = bambooProjectKey != null ? "data-bamboo-project-key=\"" + bambooProjectKey + "\"" : "";
            String jiraIssueLink = this.isJiraServerSetup() ? String.format(RENDERED_JIRA_KEY, this.getJiraIssueTitleText(), jiraIssueKey, bambooProjectKeyAttr, jiraIssueKey, this.getJiraRedirectUrl(jiraIssueKey, bambooProjectKey), jiraIssueKey) : String.format(RENDERED_JIRA_KEY_NO_SERVER, jiraIssueKey, bambooProjectKeyAttr, jiraIssueKey);
            String regex = REPLACE_KEY_REGEX_START + jiraIssueKey + REPLACE_KEY_REGEX_END;
            renderedString = renderedString.replaceAll(regex, jiraIssueLink);
        }
        return renderedString;
    }

    @NotNull
    private String getJiraRedirectUrl(@NotNull String jiraIssueKey, @Nullable String bambooProjectKey) {
        return JiraIssueUtils.getJiraRedirectUrl(this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl(), jiraIssueKey, bambooProjectKey);
    }

    @NotNull
    static String getJiraRedirectUrl(String baseUrl, String jiraIssueKey, @Nullable String bambooProjectKey) {
        String redirectActionLink = baseUrl + "/project/jiraRedirect.action?jiraIssueKey=" + jiraIssueKey;
        return bambooProjectKey == null ? redirectActionLink : redirectActionLink + "&bambooProjectKey=" + bambooProjectKey;
    }

    @Nullable
    public static String getJiraUrl(@NotNull ApplicationLink applicationLink, @NotNull String issueKey) {
        if (applicationLink.getRpcUrl() == null) {
            return null;
        }
        return JiraIssueUtils.getJiraUrl(applicationLink.getRpcUrl().toString(), new JiraIssueKey(issueKey));
    }

    @Nullable
    public static String getJiraDisplayUrl(@NotNull ApplicationLink applicationLink, @NotNull String issueKey) {
        if (applicationLink.getDisplayUrl() == null) {
            return null;
        }
        return JiraIssueUtils.getJiraUrl(applicationLink.getDisplayUrl().toString(), new JiraIssueKey(issueKey));
    }

    @NotNull
    public static String getJiraIssueUrl(@NotNull String host, @NotNull JiraIssueKey issueKey, @Nullable JiraPanel panel) {
        String issueUrl = host + "/browse/" + issueKey;
        return panel == null ? issueUrl : issueUrl + "?" + JiraIssueUtils.getPanelParameter(panel);
    }

    private static String getPanelParameter(@NotNull JiraPanel panel) {
        switch (panel) {
            case BAMBOO_BUILD: {
                return "page=com.atlassian.jira.plugin.ext.bamboo%3Abamboo-build-results-tabpanel&devStatusDetailDialog=build";
            }
        }
        return "";
    }

    @Nullable
    private static String getJiraUrl(@Nullable String host, @NotNull JiraIssueKey issueKey) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return null;
        }
        assert (host != null);
        return JiraIssueUtils.getJiraIssueUrl(host, issueKey, JiraPanel.BAMBOO_BUILD);
    }

    protected String getJiraIssueTitleText() {
        String i18nKey = "issue.link.jira.title";
        return (String)StringUtils.defaultIfEmpty((CharSequence)TextProviderUtils.getText("issue.link.jira.title"), (CharSequence)"issue.link.jira.title");
    }

    @NotNull
    public List<LinkedJiraIssue> getFilteredJiraIssues(@Nullable Collection<LinkedJiraIssue> possibleIssues, int numberNeeded) {
        if (CollectionUtils.isEmpty(possibleIssues)) {
            return Collections.emptyList();
        }
        ArrayList<LinkedJiraIssue> issuesToShow = new ArrayList<LinkedJiraIssue>(this.getFilteredFixedJiraIssues(possibleIssues, numberNeeded));
        if (issuesToShow.size() < numberNeeded) {
            issuesToShow.addAll(this.getFilteredRelatedJiraIssues(possibleIssues, numberNeeded - issuesToShow.size()));
        }
        return LinkedJiraIssueComparator.ORDERING.immutableSortedCopy(issuesToShow);
    }

    @NotNull
    public List<LinkedJiraIssue> getFilteredFixedJiraIssues(@Nullable Collection<LinkedJiraIssue> possibleIssues, int numberNeeded) {
        if (CollectionUtils.isEmpty(possibleIssues)) {
            return Collections.emptyList();
        }
        return possibleIssues.stream().filter(JiraIssuePredicates::isIssueFixed).sorted(LinkedJiraIssueComparator.COMPARATOR).limit(numberNeeded).collect(Collectors.toList());
    }

    @NotNull
    public List<LinkedJiraIssue> getFilteredRelatedJiraIssues(@Nullable Collection<LinkedJiraIssue> possibleIssues, int numberNeeded) {
        if (CollectionUtils.isEmpty(possibleIssues)) {
            return Collections.emptyList();
        }
        return possibleIssues.stream().filter(JiraIssuePredicates::isIssueRelated).sorted(LinkedJiraIssueComparator.COMPARATOR).limit(numberNeeded).collect(Collectors.toList());
    }

    @Override
    public boolean isJiraServerSetup() {
        return this.jiraApplinksService.hasJiraApplicationLink();
    }

    public static Function<JiraXmlSearchResultItemEntity, JiraIssueDetails> buildJiraIssueDetailsFromSearchResultFunction(final @NotNull ApplicationLink applicationLink, final JiraIssueDetailsBuilderFactory jiraIssueDetailsBuilderFactory) {
        return new Function<JiraXmlSearchResultItemEntity, JiraIssueDetails>(){

            public JiraIssueDetails apply(@Nullable JiraXmlSearchResultItemEntity input) {
                JiraXmlSearchResultItemEntity searchItem = (JiraXmlSearchResultItemEntity)Preconditions.checkNotNull((Object)input);
                return jiraIssueDetailsBuilderFactory.builder().displayUrl(applicationLink).issueKey(searchItem.getKey()).status(searchItem.getStatus()).summary(searchItem.getSummary()).type(searchItem.getType()).assignee(searchItem.getAssignee()).fixVersions(searchItem.getFixVersions() == null ? Collections.emptyList() : searchItem.getFixVersions()).build();
            }
        };
    }

    public static Function<InternalLinkedJiraIssue, String> transformJiraIssueToJiraIssueKey() {
        return InternalLinkedJiraIssue::getIssueKey;
    }

    void setJiraApplinksService(JiraApplinksService jiraApplinksService) {
        this.jiraApplinksService = jiraApplinksService;
    }

    void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public static enum JiraPanel {
        BAMBOO_BUILD;

    }
}

