/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.jiraissues;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.host.spi.DefaultEntityReference;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.bamboo.applinks.ApplinkPredicates;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.applinks.JiraApplinksService;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetailsBuilderFactory;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.jira.jiraissues.JiraRemoteIssueManager;
import com.atlassian.bamboo.jira.jiraissues.xml.JiraApplinksEntities;
import com.atlassian.bamboo.jira.jiraissues.xml.JiraXmlSearchResultEntity;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.DoubleThrowingPredicate;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraRemoteIssueManagerImpl
implements JiraRemoteIssueManager {
    private static final Logger log = Logger.getLogger(JiraRemoteIssueManagerImpl.class);
    static final String XML_SEARCH_URL = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml";
    static final int XML_SEARCH_MAX_QUERY_SIZE = 100;
    private final JiraApplinksService jiraApplinksService;
    private final JiraIssueDetailsBuilderFactory jiraIssueDetailsBuilderFactory;

    public JiraRemoteIssueManagerImpl(JiraApplinksService jiraApplinksService, JiraIssueDetailsBuilderFactory jiraIssueDetailsBuilderFactory) {
        this.jiraApplinksService = jiraApplinksService;
        this.jiraIssueDetailsBuilderFactory = jiraIssueDetailsBuilderFactory;
    }

    @NotNull
    public Result<CredentialsRequiredException, List<JiraIssueDetails>> fetchIssueDetailsFromJira(@NotNull ApplicationLink applicationLink, @NotNull String jiraProjectKey, @NotNull Set<String> jiraIssueKeys) {
        LinkedList result = new LinkedList();
        for (List issueKeysBatch : Iterables.partition(jiraIssueKeys, (int)100)) {
            Result<CredentialsRequiredException, Iterable<JiraIssueDetails>> partialResult = this.fetchPartitionedIssueDetailsFromJira(applicationLink, jiraProjectKey, issueKeysBatch);
            if (partialResult.hasException()) {
                return Result.exception((Throwable)partialResult.getException());
            }
            Iterables.addAll(result, (Iterable)((Iterable)partialResult.getResult()));
        }
        return Result.result(result);
    }

    @NotNull
    public Iterable<EntityReference> fetchProjectInformationFromJira(@NotNull ApplicationLink applicationLink) throws CredentialsRequiredContextException, ResponseException {
        ApplicationLinkRequest request;
        final EntityType jiraProjectEntityType = this.jiraApplinksService.getJiraProjectEntityType();
        final ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        try {
            request = requestFactory.createRequest(Request.MethodType.GET, "rest/applinks/1.0/entities");
        }
        catch (CredentialsRequiredException e) {
            throw new CredentialsRequiredContextException(applicationLink.getName(), e);
        }
        try {
            Result result = (Result)request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<Result<CredentialsRequiredException, Iterable<EntityReference>>>(){

                public Result<CredentialsRequiredException, Iterable<EntityReference>> credentialsRequired(Response response) throws ResponseException {
                    return JiraRemoteIssueManagerImpl.this.credentialsRequiredException(requestFactory);
                }

                public Result<CredentialsRequiredException, Iterable<EntityReference>> handle(Response response) throws ResponseException {
                    switch (response.getStatusCode()) {
                        case 200: {
                            List entityReferenceList = Optional.ofNullable(((JiraApplinksEntities)response.getEntity(JiraApplinksEntities.class)).getItems()).orElseGet(Collections::emptyList).stream().map(entity -> new DefaultEntityReference(entity.getKey(), entity.getName(), jiraProjectEntityType)).collect(Collectors.toList());
                            return Result.result(entityReferenceList);
                        }
                        case 401: {
                            return JiraRemoteIssueManagerImpl.this.credentialsRequiredException(requestFactory);
                        }
                    }
                    return Result.result(Collections.emptyList());
                }
            });
            if (!result.hasException()) {
                return (Iterable)result.getResult();
            }
            throw new CredentialsRequiredContextException(applicationLink.getName(), (CredentialsRequiredException)result.getException());
        }
        catch (ResponseException e) {
            String message = String.format("Unable to fetch project information from Jira server: %s (%s)", applicationLink.getName(), applicationLink.getRpcUrl());
            throw new ResponseException(message, (Throwable)e);
        }
    }

    private <T> Result<CredentialsRequiredException, T> credentialsRequiredException(ApplicationLinkRequestFactory requestFactory) {
        return Result.exception((Throwable)new CredentialsRequiredException((AuthorisationURIGenerator)requestFactory, "Credentials required"));
    }

    public ApplicationLink getJiraApplicationLink(@NotNull String jiraProjectKey, @Nullable Project project) throws CredentialsRequiredContextException, ResponseException {
        ApplicationLink foundApplicationLink = null;
        if (project != null) {
            foundApplicationLink = BambooIterables.stream((Iterable)this.jiraApplinksService.getJiraEntityLinksForProject(project)).filter(ApplinkPredicates.entityLinkKeyEqual(jiraProjectKey)).findFirst().map(EntityLink::getApplicationLink).orElse(null);
        }
        if (foundApplicationLink == null) {
            Iterable appLinks = this.jiraApplinksService.getJiraApplicationLinks();
            foundApplicationLink = (ApplicationLink)BambooIterables.find((Iterable)appLinks, (DoubleThrowingPredicate)new AppContainsProject(jiraProjectKey), null);
        }
        return foundApplicationLink;
    }

    protected Result<CredentialsRequiredException, Iterable<JiraIssueDetails>> fetchPartitionedIssueDetailsFromJira(final @NotNull ApplicationLink applicationLink, @NotNull String jiraProjectKey, @NotNull List<String> jiraIssueKeysBatch) {
        Preconditions.checkArgument((!jiraIssueKeysBatch.isEmpty() ? 1 : 0) != 0, (Object)"Argument issueKeys must not be empty");
        Preconditions.checkArgument((jiraIssueKeysBatch.size() <= 100 ? 1 : 0) != 0, (String)"Cannot handle more than %s issue keys", (Object[])new Object[]{Integer.toString(100)});
        final ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        try {
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, this.constructSearchUrl(jiraProjectKey, jiraIssueKeysBatch));
            return (Result)request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<Result<CredentialsRequiredException, Iterable<JiraIssueDetails>>>(){

                public Result<CredentialsRequiredException, Iterable<JiraIssueDetails>> credentialsRequired(Response response) throws ResponseException {
                    return JiraRemoteIssueManagerImpl.this.credentialsRequiredException(requestFactory);
                }

                public Result<CredentialsRequiredException, Iterable<JiraIssueDetails>> handle(Response response) throws ResponseException {
                    switch (response.getStatusCode()) {
                        case 200: {
                            List jiraIssueDetails = BambooIterables.stream(((JiraXmlSearchResultEntity)response.getEntity(JiraXmlSearchResultEntity.class)).getItems()).map(arg_0 -> JiraIssueUtils.buildJiraIssueDetailsFromSearchResultFunction(applicationLink, JiraRemoteIssueManagerImpl.this.jiraIssueDetailsBuilderFactory).apply(arg_0)).collect(Collectors.toList());
                            return Result.result(jiraIssueDetails);
                        }
                        case 401: {
                            return JiraRemoteIssueManagerImpl.this.credentialsRequiredException(requestFactory);
                        }
                    }
                    return Result.result(Collections.emptyList());
                }
            });
        }
        catch (ResponseException e) {
            log.warn((Object)"Response exception", (Throwable)e);
        }
        catch (CredentialsRequiredException e) {
            return Result.exception((Throwable)e);
        }
        return Result.result(Collections.emptyList());
    }

    @NotNull
    private String constructJqlQuery(@NotNull String projectKey, @NotNull List<String> issueKeys) {
        Preconditions.checkArgument((!issueKeys.isEmpty() ? 1 : 0) != 0, (Object)"Argument issueKeys must not be empty");
        return "project=\"" + projectKey + "\" AND issuekey IN(" + String.join((CharSequence)",", issueKeys) + ")";
    }

    @NotNull
    protected String constructSearchUrl(@NotNull String projectKey, @NotNull List<String> issueKeys) {
        return "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=" + EscapeChars.forFormSubmission((String)this.constructJqlQuery(projectKey, issueKeys)) + "&tempMax=" + 100 + "&field=summary&field=type&field=status&field=link&field=assignee&field=fixVersions&validateQuery=false";
    }

    private class AppContainsProject
    implements DoubleThrowingPredicate<ApplicationLink, CredentialsRequiredContextException, ResponseException> {
        private final String jiraProjectKey;

        public AppContainsProject(String jiraProjectKey) {
            this.jiraProjectKey = jiraProjectKey;
        }

        public boolean apply(ApplicationLink appLink) throws CredentialsRequiredContextException, ResponseException {
            return BambooIterables.stream(JiraRemoteIssueManagerImpl.this.fetchProjectInformationFromJira(appLink)).anyMatch(entityReference -> this.jiraProjectKey.equals(entityReference.getKey()));
        }
    }
}

