/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.jiraissues;

import com.atlassian.bamboo.jira.jiraissues.InternalLinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.google.common.collect.Ordering;
import java.util.Comparator;

public class LinkedJiraIssueComparator
implements Comparator<InternalLinkedJiraIssue> {
    public static final Comparator<InternalLinkedJiraIssue> COMPARATOR = new LinkedJiraIssueComparator();
    public static final Ordering<InternalLinkedJiraIssue> ORDERING = Ordering.from(COMPARATOR);

    private LinkedJiraIssueComparator() {
    }

    @Override
    public int compare(InternalLinkedJiraIssue o1, InternalLinkedJiraIssue o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        int typeComparison = this.compareTypes(o1.getIssueType(), o2.getIssueType());
        if (typeComparison == 0) {
            return this.compareKeys(o1.getIssueKey(), o2.getIssueKey());
        }
        return typeComparison;
    }

    private int compareTypes(JiraIssueLinkType type1, JiraIssueLinkType type2) {
        return Integer.signum(type2.compareTo((Enum)type1));
    }

    private int compareKeys(String key1, String key2) {
        if (key1 == null && key2 == null) {
            return 0;
        }
        if (key1 == null) {
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        int index1 = key1.lastIndexOf(45);
        int index2 = key2.lastIndexOf(45);
        if (index1 == -1 && index2 == -1) {
            return 0;
        }
        if (index1 == -1) {
            return 1;
        }
        if (index2 == -1) {
            return -1;
        }
        for (int i = 0; i < Math.min(index1, index2); ++i) {
            char c2;
            char c1 = key1.charAt(i);
            if (c1 == (c2 = key2.charAt(i))) continue;
            return c1 < c2 ? -1 : 1;
        }
        if (index1 != index2) {
            return index1 < index2 ? -1 : 1;
        }
        return this.compareNumPart(key1, key2);
    }

    private int compareNumPart(String key1, String key2) {
        if (key1.length() == key2.length()) {
            return key1.compareTo(key2);
        }
        return key1.length() > key2.length() ? 1 : -1;
    }
}

