/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.jiraissues;

import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="BRS_LINKEDJIRAISSUES")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class LinkedJiraIssueImpl
extends BambooEntityObject
implements LinkedJiraIssue {
    private String issueKey;
    private JiraIssueLinkType issueLinkType;
    private ResultsSummary resultsSummary;
    private JiraIssueDetails jiraIssueDetails;

    public LinkedJiraIssueImpl() {
    }

    public LinkedJiraIssueImpl(String issueKey) {
        this(issueKey, JiraIssueLinkType.BUILD_RELATES);
    }

    public LinkedJiraIssueImpl(String issueKey, JiraIssueLinkType issueLinkType) {
        this.issueKey = issueKey;
        this.issueLinkType = issueLinkType;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    @NotNull
    public String getIssueKey() {
        return this.issueKey;
    }

    public ResultsSummary getResultsSummary() {
        return this.resultsSummary;
    }

    public void setResultsSummary(ResultsSummary resultsSummary) {
        this.resultsSummary = resultsSummary;
    }

    public JiraIssueLinkType getIssueType() {
        return this.issueLinkType;
    }

    public void setIssueType(JiraIssueLinkType issueLinkType) {
        this.issueLinkType = issueLinkType;
    }

    public JiraIssueDetails getJiraIssueDetails() {
        return this.jiraIssueDetails;
    }

    public void setJiraIssueDetails(JiraIssueDetails jiraIssueDetails) {
        this.jiraIssueDetails = jiraIssueDetails;
    }

    public int hashCode() {
        return new HashCodeBuilder(123, 7).append((Object)this.issueKey).append((Object)this.issueLinkType.getLinkType()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LinkedJiraIssueImpl)) {
            return false;
        }
        LinkedJiraIssueImpl rhs = (LinkedJiraIssueImpl)((Object)o);
        return new EqualsBuilder().append((Object)this.issueKey, (Object)rhs.issueKey).append((Object)this.issueLinkType.getLinkType(), (Object)rhs.issueLinkType.getLinkType()).isEquals();
    }

    public int compareTo(LinkedJiraIssue o) {
        return new CompareToBuilder().append((Object)this.issueKey, (Object)o.getIssueKey()).append((Object)this.issueLinkType.getLinkType(), (Object)o.getIssueType().getLinkType()).toComparison();
    }

    public String toString() {
        return String.format("%s (%s)", this.issueKey, this.issueLinkType);
    }
}

