/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.bamboo.applinks.ApplicationLinkRequestUtils;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.jira.rest.Errors;
import com.atlassian.bamboo.jira.rest.JiraRestResponse;
import com.atlassian.bamboo.jira.rest.JiraRestService;
import com.atlassian.bamboo.security.applinks.BambooHostApplication;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseTimeoutException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.TextProvider;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraRestServiceImpl
implements JiraRestService {
    private static final Logger log = Logger.getLogger(JiraRestServiceImpl.class);
    private static int JIRA_50_BUILDNUMBER = 713;
    private final TextProvider textProvider;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final BambooHostApplication bambooHostApplication;
    private BambooUrl bambooUrl;

    public JiraRestServiceImpl(TextProvider textProvider, AdministrationConfigurationAccessor administrationConfigurationAccessor, BambooHostApplication bambooHostApplication) {
        this.textProvider = textProvider;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.bambooHostApplication = bambooHostApplication;
    }

    @NotNull
    public JiraRestResponse doRestCallViaApplink(@NotNull ApplicationLink applicationLink, @NotNull String requestUrl, @NotNull Request.MethodType methodType, @Nullable JSONObject data) throws CredentialsRequiredContextException {
        return this.doRestCallViaApplink(applicationLink, requestUrl, methodType, data, null);
    }

    @NotNull
    public JiraRestResponse doRestCallViaApplink(@NotNull ApplicationLink applicationLink, @NotNull String requestUrl, @NotNull Request.MethodType methodType, @Nullable JSONObject data, @Nullable Class<? extends AuthenticationProvider> providerClass) throws CredentialsRequiredContextException {
        ApplicationLinkRequestFactory requestFactory = providerClass == null ? applicationLink.createAuthenticatedRequestFactory() : applicationLink.createAuthenticatedRequestFactory(providerClass);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing Jira request. " + methodType + " " + applicationLink.getDisplayUrl() + "/" + requestUrl));
            }
            ApplicationLinkRequest request = requestFactory.createRequest(methodType, requestUrl);
            if (methodType != Request.MethodType.GET && data != null) {
                request.setRequestBody(data.toString(), "application/json");
            }
            request.setSoTimeout((int)TimeUnit.SECONDS.toMillis(30L));
            JiraRestResponse response = (JiraRestResponse)ApplicationLinkRequestUtils.execute((ApplicationLinkRequestFactory)requestFactory, (ApplicationLinkRequest)request, (ReturningResponseHandler)new JiraResponseHandler());
            response = this.validateJiraNotBelowFiveZero(response, applicationLink, requestFactory);
            if (response.hasErrors()) {
                log.warn((Object)("Failed to execute application link request. Server: " + applicationLink.getDisplayUrl() + " Method: " + methodType + " Url: " + requestUrl + "\nResponse: " + response.statusCode + " " + response.statusMessage + "\nErrors: " + response.errors.toString()));
                if (log.isDebugEnabled() && StringUtils.isNotBlank((CharSequence)response.body)) {
                    log.debug((Object)("Response body: " + response.body));
                }
            }
            return response;
        }
        catch (ResponseTimeoutException e) {
            log.warn((Object)("Request to Jira timed out. Server: " + applicationLink.getDisplayUrl() + " Method: " + methodType + " Url: " + requestUrl));
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new JiraRestResponse("Request to Jira timed out: " + e.getMessage());
        }
        catch (ResponseException e) {
            log.warn((Object)("Failed to execute Jira request. Server: " + applicationLink.getDisplayUrl() + " Method: " + methodType + " Url: " + requestUrl));
            log.warn((Object)e.getMessage(), (Throwable)e);
            return new JiraRestResponse("Request to Jira failed: " + e.getMessage());
        }
        catch (CredentialsRequiredException e) {
            log.info((Object)("Authentication was required, but credentials were not available when doing applink call. Server: " + applicationLink.getDisplayUrl() + " Method: " + methodType + " Url: " + requestUrl));
            throw new CredentialsRequiredContextException(applicationLink.getName(), e);
        }
    }

    @NotNull
    public JSONObject getRemoteIssueLinkJson(@NotNull String globalId, @NotNull String text, @NotNull String key, @NotNull String relationship, @NotNull String relativeUrl, String iconLocation) throws JSONException {
        JSONObject issueLinkData = new JSONObject().put("globalId", (Object)("appId=" + this.bambooHostApplication.getId().get() + "&" + globalId)).put("application", (Object)new JSONObject().put("type", (Object)"com.atlassian.bamboo").put("name", (Object)this.getInstanceName())).put("relationship", (Object)relationship).put("object", (Object)new JSONObject().put("url", (Object)this.getBambooUrl().withBaseUrlFromConfiguration(relativeUrl)).put("title", (Object)text).put("summary", (Object)key).put("icon", (Object)new JSONObject().put("url16x16", (Object)iconLocation).put("title", (Object)"Plan Status")));
        return issueLinkData;
    }

    private JiraRestResponse validateJiraNotBelowFiveZero(JiraRestResponse originalResponse, ApplicationLink applicationLink, ApplicationLinkRequestFactory requestFactory) {
        if (originalResponse.statusCode == 404) {
            log.debug((Object)("404 Received from " + applicationLink.getName() + ".  Checking the version."));
            try {
                ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, "/rest/api/latest/serverInfo");
                request.setSoTimeout((int)TimeUnit.SECONDS.toMillis(30L));
                JiraRestResponse validationResponse = (JiraRestResponse)ApplicationLinkRequestUtils.execute((ApplicationLinkRequestFactory)requestFactory, (ApplicationLinkRequest)request, (ReturningResponseHandler)new JiraResponseHandler());
                if (!validationResponse.hasErrors() && validationResponse.entity != null) {
                    int buildNumber = validationResponse.entity.getInt("buildNumber");
                    String version = validationResponse.entity.getString("version");
                    if (buildNumber < JIRA_50_BUILDNUMBER) {
                        JiraRestResponse.JiraRestResponseBuilder responseBuilder = new JiraRestResponse.JiraRestResponseBuilder(originalResponse.statusCode, originalResponse.statusMessage);
                        responseBuilder.addError(this.textProvider.getText("jira.create.serverTooOld", new String[]{applicationLink.getName(), version}));
                        return responseBuilder.build();
                    }
                    log.debug((Object)"The Jira version is actually high enough to support create issue.  Perhaps it was an intermittent failure the first time...");
                } else {
                    log.debug((Object)("Checking of Jira server version also generated some errors" + validationResponse.toString()));
                }
            }
            catch (Exception e) {
                log.debug((Object)("Checking of Jira server version also generated some errors" + e.getMessage()));
            }
        }
        return originalResponse;
    }

    @Nullable
    private String getInstanceName() {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        return administrationConfiguration != null ? administrationConfiguration.getInstanceName() : null;
    }

    private AdministrationConfiguration getAdministrationConfiguration() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration();
    }

    private BambooUrl getBambooUrl() {
        if (this.bambooUrl == null) {
            this.bambooUrl = new BambooUrl(this.administrationConfigurationAccessor);
        }
        return this.bambooUrl;
    }

    static class JiraResponseHandler
    implements ReturningResponseHandler<Response, JiraRestResponse> {
        JiraResponseHandler() {
        }

        public JiraRestResponse handle(Response response) {
            JiraRestResponse.JiraRestResponseBuilder respBuilder = new JiraRestResponse.JiraRestResponseBuilder(response.getStatusCode(), response.getStatusText());
            if (!response.isSuccessful()) {
                try {
                    respBuilder.errors((Errors)response.getEntity(Errors.class));
                }
                catch (Exception entityException) {
                    try {
                        String responseString = IOUtil.toString((InputStream)response.getResponseBodyAsStream());
                        if (StringUtils.isNotBlank((CharSequence)responseString)) {
                            respBuilder.body(responseString);
                            respBuilder.addError("Request to Jira failed. Returned with " + response.getStatusCode() + ". Response: " + responseString);
                        }
                    }
                    catch (Exception bodyException) {
                        respBuilder.addError("Request to Jira failed. Returned with " + response.getStatusCode());
                    }
                }
            } else {
                try {
                    String responseString = IOUtil.toString((InputStream)response.getResponseBodyAsStream());
                    respBuilder.body(responseString);
                    if (StringUtils.isNotBlank((CharSequence)responseString)) {
                        try {
                            JSONObject jsonObject = new JSONObject(responseString);
                            respBuilder.entity(jsonObject);
                        }
                        catch (JSONException e) {
                            respBuilder.addError("Failed to parse response: " + e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to extract body of Jira's response", (Throwable)e);
                }
            }
            return respBuilder.build();
        }
    }
}

