/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.key;

import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyGenerator {
    private static final Logger log = Logger.getLogger(KeyGenerator.class);
    private static final Set<String> IGNORED_WORDS = ImmutableSet.of((Object)"THE", (Object)"A", (Object)"AN", (Object)"AS", (Object)"AND", (Object)"IN", (Object[])new String[]{"OF", "OR", ""});
    private static final Map<Character, String> TRANSLATION_TABLE = ImmutableMap.builder().put((Object)Character.valueOf('\u00c0'), (Object)"A").put((Object)Character.valueOf('\u00c1'), (Object)"A").put((Object)Character.valueOf('\u00c2'), (Object)"A").put((Object)Character.valueOf('\u00c3'), (Object)"A").put((Object)Character.valueOf('\u00c4'), (Object)"A").put((Object)Character.valueOf('\u00c5'), (Object)"A").put((Object)Character.valueOf('\u00c6'), (Object)"Ae").put((Object)Character.valueOf('\u00c7'), (Object)"C").put((Object)Character.valueOf('\u00c8'), (Object)"E").put((Object)Character.valueOf('\u00c9'), (Object)"E").put((Object)Character.valueOf('\u00ca'), (Object)"E").put((Object)Character.valueOf('\u00cb'), (Object)"E").put((Object)Character.valueOf('\u00d1'), (Object)"N").put((Object)Character.valueOf('\u00d2'), (Object)"O").put((Object)Character.valueOf('\u00d3'), (Object)"O").put((Object)Character.valueOf('\u00d4'), (Object)"O").put((Object)Character.valueOf('\u00d5'), (Object)"O").put((Object)Character.valueOf('\u00d6'), (Object)"O").put((Object)Character.valueOf('\u00d8'), (Object)"O").put((Object)Character.valueOf('\u00d9'), (Object)"U").put((Object)Character.valueOf('\u00da'), (Object)"U").put((Object)Character.valueOf('\u00db'), (Object)"U").put((Object)Character.valueOf('\u00dc'), (Object)"U").put((Object)Character.valueOf('\u00e0'), (Object)"a").put((Object)Character.valueOf('\u00e1'), (Object)"a").put((Object)Character.valueOf('\u00e2'), (Object)"a").put((Object)Character.valueOf('\u00e3'), (Object)"a").put((Object)Character.valueOf('\u00e4'), (Object)"a").put((Object)Character.valueOf('\u00e5'), (Object)"a").put((Object)Character.valueOf('\u00e6'), (Object)"ae").put((Object)Character.valueOf('\u00e7'), (Object)"c").put((Object)Character.valueOf('\u00e8'), (Object)"e").put((Object)Character.valueOf('\u00e9'), (Object)"e").put((Object)Character.valueOf('\u00ea'), (Object)"e").put((Object)Character.valueOf('\u00eb'), (Object)"e").put((Object)Character.valueOf('\u00ec'), (Object)"i").put((Object)Character.valueOf('\u00ed'), (Object)"i").put((Object)Character.valueOf('\u00ee'), (Object)"i").put((Object)Character.valueOf('\u00ef'), (Object)"i").put((Object)Character.valueOf('\u00f1'), (Object)"n").put((Object)Character.valueOf('\u00f2'), (Object)"o").put((Object)Character.valueOf('\u00f3'), (Object)"o").put((Object)Character.valueOf('\u00f4'), (Object)"o").put((Object)Character.valueOf('\u00f5'), (Object)"o").put((Object)Character.valueOf('\u00f6'), (Object)"o").put((Object)Character.valueOf('\u00f9'), (Object)"u").put((Object)Character.valueOf('\u00fa'), (Object)"u").put((Object)Character.valueOf('\u00fb'), (Object)"u").put((Object)Character.valueOf('\u00fc'), (Object)"u").put((Object)Character.valueOf('\u00ff'), (Object)"y").build();

    @NotNull
    public static String generateKey(@Nullable String name, int desiredKeyLength, int maxKeyLength) {
        String key;
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        name = ((String)Preconditions.checkNotNull((Object)name)).trim();
        StringBuilder translatedNameBuilder = new StringBuilder();
        for (char c : name.toCharArray()) {
            translatedNameBuilder.append(TRANSLATION_TABLE.getOrDefault(Character.valueOf(c), String.valueOf(c)));
        }
        name = translatedNameBuilder.toString();
        List<Object> words = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Splitter.onPattern((String)"\\s+").split((CharSequence)name), (Function)Functions.compose((Function)BambooStringUtils.replaceAll((String)"[^a-zA-Z]", (String)""), StringUtils::upperCase)));
        if (desiredKeyLength > 0 && Joiner.on((String)"").join((Iterable)words).length() > desiredKeyLength) {
            words = words.stream().filter(word -> !KeyGenerator.isIgnoredWord(word)).collect(Collectors.toList());
        }
        switch (words.size()) {
            case 0: {
                key = "";
                break;
            }
            case 1: {
                String word2 = (String)Iterables.getOnlyElement((Iterable)words);
                if (desiredKeyLength > 0 && word2.length() > desiredKeyLength) {
                    int index = StringUtils.indexOfAny((CharSequence)word2, (String)"AEIOUY");
                    if (index == 0) {
                        ++index;
                    }
                    key = index != -1 ? StringUtils.substring((String)word2, (int)0, (int)(index + 1)) : word2;
                    break;
                }
                key = word2;
                break;
            }
            default: {
                key = KeyGenerator.createAcronym(words);
            }
        }
        if (maxKeyLength > 0 && key.length() > maxKeyLength) {
            key = key.substring(0, maxKeyLength);
        }
        return key;
    }

    private static boolean isIgnoredWord(String word) {
        return IGNORED_WORDS.contains(word);
    }

    private static String createAcronym(@NotNull Iterable<String> words) {
        return BambooIterables.stream(words).filter(StringUtils::isNotEmpty).map(s -> Character.valueOf(s.charAt(0))).map(String::valueOf).collect(Collectors.joining());
    }
}

