/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.labels;

import com.atlassian.bamboo.event.ChainUpdatedEvent;
import com.atlassian.bamboo.event.PlanFavouriteAddedEvent;
import com.atlassian.bamboo.event.PlanFavouriteRemovedEvent;
import com.atlassian.bamboo.event.ResultLabelAddedEvent;
import com.atlassian.bamboo.event.ResultLabelRemovedEvent;
import com.atlassian.bamboo.index.BuildResultsIndexer;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelCount;
import com.atlassian.bamboo.labels.LabelDao;
import com.atlassian.bamboo.labels.LabelImpl;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.labels.LabelParser;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.labels.LabellingImpl;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelManagerImpl
implements LabelManager {
    private static final Logger log = Logger.getLogger(LabelManagerImpl.class);
    private final LabelDao labelDao;
    private final BuildResultsIndexer buildResultsIndexer;
    private final EventPublisher eventPublisher;
    private final JiraIssueUtils jiraIssueUtils;
    private final PlanManager planManager;
    private final ProjectManager projectManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final Object labelsLock = new Object();

    public LabelManagerImpl(LabelDao labelDao, BuildResultsIndexer buildResultsIndexer, JiraIssueUtils jiraIssueUtils, PlanManager planManager, ProjectManager projectManager, ResultsSummaryManager resultsSummaryManager, EventPublisher eventPublisher) {
        this.labelDao = labelDao;
        this.buildResultsIndexer = buildResultsIndexer;
        this.eventPublisher = eventPublisher;
        this.jiraIssueUtils = jiraIssueUtils;
        this.planManager = planManager;
        this.projectManager = projectManager;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void saveLabelling(Labelling labelling) {
        this.labelDao.saveLabelling(labelling);
    }

    public int addLabel(@Nullable String labelName, @Nullable PlanResultKey planResultKey, @Nullable User user) {
        if (StringUtils.isEmpty((CharSequence)labelName) || planResultKey == null) {
            return 0;
        }
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey, ResultDataRead.EAGER);
        if (resultsSummary == null) {
            return 0;
        }
        String validatedLabelName = LabelParser.replaceInvalidCharacters(labelName, "_");
        try {
            int result = this.withWriteLock(() -> {
                if (!PlanKeys.isJobKey((PlanKey)planResultKey.getPlanKey())) {
                    Plan plan = this.planManager.getPlanByKey(planResultKey.getPlanKey(), Plan.class);
                    return this.addLabel(validatedLabelName, "label", plan.getProject(), plan, resultsSummary, user != null ? user.getName() : null);
                }
                Project project = this.projectManager.getProjectByKey(PlanKeys.getProjectKeyPart((PlanKey)planResultKey.getPlanKey()));
                return this.addLabel(validatedLabelName, "label", project, null, resultsSummary, user != null ? user.getName() : null);
            });
            if (result != 0) {
                this.eventPublisher.publish((Object)new ResultLabelAddedEvent(this, planResultKey, validatedLabelName, user));
            }
            this.jiraIssueUtils.findAndSaveJiraIssueKeys(validatedLabelName.toUpperCase(), resultsSummary);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot add label '%s' to build results '%s'", labelName, planResultKey.getKey()), e);
        }
    }

    public int addLabel(@Nullable String labelName, @Nullable PlanKey planKey, @Nullable User user) {
        int result = this.addLabelNoEvent(labelName, planKey, user);
        if (result != 0) {
            this.eventPublisher.publish((Object)new ChainUpdatedEvent(this, planKey));
        }
        return result;
    }

    public boolean addLabels(List<String> labelNames, @Nullable PlanKey planKey, @Nullable User user) {
        boolean change = false;
        for (String labelName : labelNames) {
            int result = this.addLabelNoEvent(labelName, planKey, user);
            change = change || result != 0;
        }
        if (change) {
            this.eventPublisher.publish((Object)new ChainUpdatedEvent(this, planKey));
        }
        return change;
    }

    private int addLabelNoEvent(@Nullable String labelName, @Nullable PlanKey planKey, @Nullable User user) {
        if (StringUtils.isEmpty((CharSequence)labelName) || planKey == null) {
            return 0;
        }
        String validatedLabelName = LabelParser.replaceInvalidCharacters(labelName, "_");
        try {
            return this.withWriteLock(() -> {
                Plan plan = this.planManager.getPlanByKey(planKey, Plan.class);
                return this.addLabel(validatedLabelName, "label", plan.getProject(), plan, null, user != null ? user.getName() : null);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot add label '%s' to plan '%s'", labelName, planKey), e);
        }
    }

    public int addFavourite(final Plan plan, final User user) {
        if (user == null) {
            return 0;
        }
        try {
            int result = this.withWriteLock(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (!LabelManagerImpl.this.isFavourite((ImmutablePlan)plan, user)) {
                        return LabelManagerImpl.this.addLabel(":favourite", user.getName(), plan.getProject(), plan, null, user.getName());
                    }
                    return 0;
                }
            });
            if (result != 0) {
                this.eventPublisher.publish((Object)new PlanFavouriteAddedEvent(this, plan.getPlanKey(), user));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot add favourite to plan '%s'", plan.getKey()), e);
        }
    }

    public int removeLabel(String labelName, final @Nullable PlanResultKey planResultKey, User user) {
        if (StringUtils.isEmpty((CharSequence)labelName) || planResultKey == null) {
            return 0;
        }
        final ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey, ResultDataRead.EAGER);
        if (resultsSummary == null) {
            return 0;
        }
        final String validatedLabelName = LabelParser.replaceInvalidCharacters(labelName, "_");
        try {
            int result = this.withWriteLock(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (!PlanKeys.isJobKey((PlanKey)planResultKey.getPlanKey())) {
                        Plan plan = LabelManagerImpl.this.planManager.getPlanByKey(planResultKey.getPlanKey(), Plan.class);
                        return LabelManagerImpl.this.removeLabel(validatedLabelName, "label", plan.getProject(), (ImmutablePlan)plan, resultsSummary);
                    }
                    Project project = LabelManagerImpl.this.projectManager.getProjectByKey(PlanKeys.getProjectKeyPart((PlanKey)planResultKey.getPlanKey()));
                    return LabelManagerImpl.this.removeLabel(validatedLabelName, "label", project, null, resultsSummary);
                }
            });
            if (result != 0) {
                this.eventPublisher.publish((Object)new ResultLabelRemovedEvent(this, planResultKey, validatedLabelName, user));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot remove label '%s' from build results '%s'", labelName, planResultKey.getKey()), e);
        }
    }

    public int removeLabel(@Nullable String labelName, final @Nullable PlanKey planKey, @Nullable User user) {
        if (StringUtils.isEmpty((CharSequence)labelName) || planKey == null) {
            return 0;
        }
        final String validatedLabelName = LabelParser.replaceInvalidCharacters(labelName, "_");
        try {
            int result = this.withWriteLock(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    Plan plan = LabelManagerImpl.this.planManager.getPlanByKey(planKey, Plan.class);
                    return LabelManagerImpl.this.removeLabel(validatedLabelName, "label", plan.getProject(), (ImmutablePlan)plan, null);
                }
            });
            if (result != 0) {
                this.eventPublisher.publish((Object)new ChainUpdatedEvent(this, planKey));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot remove label '%s' from plan '%s'", labelName, planKey.getKey()), e);
        }
    }

    @NotNull
    public Set<Label> getAllPlanLabels() {
        return this.labelDao.findPlanLabels("label");
    }

    @NotNull
    public Set<Label> getPlanLabels(@NotNull ImmutablePlan plan) {
        return this.labelDao.findPlanLabels("label", (PlanIdentifier)plan);
    }

    public int removeFavourite(final @NotNull Plan plan, final @Nullable User user) {
        if (user == null) {
            return 0;
        }
        try {
            int result = this.withWriteLock(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (LabelManagerImpl.this.isFavourite((ImmutablePlan)plan, user)) {
                        String userName = user.getName();
                        int removed = LabelManagerImpl.this.removeLabel(":favourite", userName, plan.getProject(), (ImmutablePlan)plan, null);
                        LabelManagerImpl.this.addLabel(":unmark-favourite", userName, plan.getProject(), plan, null, userName);
                        return removed;
                    }
                    return 0;
                }
            });
            if (result != 0) {
                this.eventPublisher.publish((Object)new PlanFavouriteRemovedEvent(this, plan.getPlanKey(), user));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot remove favourite from plan '%s'", plan.getKey()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R withWriteLock(Callable<R> callable) throws Exception {
        Object object = this.labelsLock;
        synchronized (object) {
            return callable.call();
        }
    }

    public boolean hasBuildResultsLabel(@NotNull ResultsSummary buildResultsSummary, @NotNull String label) {
        return this.labelDao.findLabellingByResultsSummary(label, "label", buildResultsSummary) != null;
    }

    public boolean hasPlanLabel(@NotNull Plan plan, @NotNull String label) {
        return this.labelDao.findLabellingByBuild(label, "label", (ImmutablePlan)plan) != null;
    }

    public Collection<Label> getLabelsByName(List<String> labelNames) {
        return this.labelDao.findLabelsByNameAndNamespace(labelNames, "label");
    }

    @NotNull
    public List<ResultsSummary> findBuildResultsSummaryByLabel(@NotNull String labelName) {
        return this.labelDao.findResultsSummaryByNameAndNamespace(labelName, "label");
    }

    public boolean isFavourite(@NotNull ImmutablePlan plan, @Nullable User user) {
        if (user == null || plan instanceof ImmutableJob) {
            return false;
        }
        return this.labelDao.findLabellingByBuild(":favourite", user.getName(), plan) != null;
    }

    public boolean isManuallyUnmarkedFavourite(@NotNull Plan plan, @Nullable User user) {
        if (user == null) {
            return false;
        }
        return this.labelDao.findLabellingByBuild(":unmark-favourite", user.getName(), (ImmutablePlan)plan) != null;
    }

    public List<String> getFavouritesForPlan(Plan plan) {
        return this.getFavouritesForPlan((ImmutablePlan)plan);
    }

    @NotNull
    public List<String> getFavouritesForPlan(@NotNull ImmutablePlan plan) {
        return this.labelDao.findLabels(plan).stream().filter(labelling -> ":favourite".equals(labelling.getLabel().getName())).map(Labelling::getUserName).collect(Collectors.toList());
    }

    @NotNull
    public List<LabelCount> findLabels(@NotNull String namespace, int maxResults, @Nullable Plan plan, @Nullable Project project) {
        if (plan != null) {
            return this.labelDao.findLabels(namespace, maxResults, plan);
        }
        if (project != null) {
            return this.labelDao.findLabels(namespace, maxResults, project);
        }
        return this.labelDao.findLabels(namespace, maxResults);
    }

    protected int addLabel(@NotNull String labelName, String namespace, @Nullable Project project, @Nullable Plan plan, @Nullable ResultsSummary resultsSummary, String userName) {
        boolean isNewLabelling;
        int addedOrCreated;
        labelName = labelName.toLowerCase();
        Date now = new Date();
        Labelling labelling = null;
        Label label = this.labelDao.findLabelByNameAndNamespace(labelName, namespace);
        if (label == null) {
            label = new LabelImpl();
            label.setName(labelName);
            label.setNamespace(namespace);
            label.setCreationDate(now);
            addedOrCreated = 1;
        } else {
            if (resultsSummary != null) {
                labelling = this.labelDao.findLabellingByResultsSummary(label, resultsSummary);
            } else if (plan != null) {
                labelling = this.labelDao.findLabellingByBuild(label, (ImmutablePlan)plan);
            } else if (project != null) {
                labelling = this.labelDao.findLabellingByProject(label, project);
            }
            addedOrCreated = 2;
        }
        boolean bl = isNewLabelling = labelling == null;
        if (isNewLabelling) {
            labelling = new LabellingImpl();
            labelling.setLabel(label);
            if (resultsSummary != null) {
                labelling.setBuildResultsSummary(resultsSummary);
            }
            if (plan != null) {
                labelling.setPlan(plan);
            }
            if (project != null) {
                labelling.setProject(project);
            }
            labelling.setCreationDate(now);
            labelling.setLastModificationDate(now);
            labelling.setUserName(userName);
            label.setLastModificationDate(now);
            this.labelDao.saveLabel(label);
            this.labelDao.saveLabelling(labelling);
            if (resultsSummary != null) {
                resultsSummary.getLabellings().add(labelling);
                ImmutableChain chain = (ImmutableChain)Narrow.downTo((Object)plan, ImmutableChain.class);
                if (chain != null) {
                    try {
                        this.buildResultsIndexer.reIndexBuildResults(resultsSummary, chain, (ImmutablePlan)plan, false);
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
            return addedOrCreated;
        }
        return 0;
    }

    protected int removeLabel(@NotNull String labelName, @NotNull String namespace, @NotNull Project project, @Nullable ImmutablePlan plan, @Nullable ResultsSummary resultsSummary) {
        Label label = this.labelDao.findLabelByNameAndNamespace(labelName = labelName.toLowerCase(), namespace);
        if (label != null) {
            ImmutableChain chain;
            Labelling labelling = resultsSummary != null ? this.labelDao.findLabellingByResultsSummary(label, resultsSummary) : (plan != null ? this.labelDao.findLabellingByBuild(label, plan) : this.labelDao.findLabellingByProject(label, project));
            if (labelling != null) {
                if (resultsSummary != null) {
                    resultsSummary.getLabellings().remove(labelling);
                }
                label.setLastModificationDate(new Date());
                this.labelDao.remove((EntityObject)labelling);
            }
            int deletedOrRemoved = 4;
            if (this.labelDao.getUsageCountForLabel(label) == 0L) {
                this.labelDao.remove((EntityObject)label);
                deletedOrRemoved = 3;
            }
            if (resultsSummary != null && (chain = (ImmutableChain)Narrow.downTo((Object)plan, ImmutableChain.class)) != null) {
                try {
                    this.buildResultsIndexer.reIndexBuildResults(resultsSummary, chain, (ImmutablePlan)chain, false);
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            return deletedOrRemoved;
        }
        return 0;
    }
}

