/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.labels;

import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelParser {
    private static final Logger log = Logger.getLogger(LabelParser.class);
    private static final char[] INVALID_LABEL_CHARACTERS = new char[]{':', ';', ',', '.', ' ', '\t', '\n', '\r', '\f', '?', '&', '[', ']', '(', ')', '#', '^', '*', '@', '!'};
    private static final char[] INVALID_CHARACTERS = ArrayUtils.addAll((char[])BambooStringUtils.XSS_RELATED_CHARACTERS, (char[])INVALID_LABEL_CHARACTERS);
    private static final String INVALID_CHARACTERS_FIND_EXPR = "[:;,\\.\\?&\\[\\]\\(\\)#\\^\\*@!\\s'\"\\\\<\\>]";
    private static final String LABEL_DELIM_CHARS = " ,";
    private static final String LABEL_DELIM = " ";

    public static boolean isValidLabelName(String name) {
        return name != null && !BambooStringUtils.containsRelatedCharacters((String)name, (char[])INVALID_CHARACTERS);
    }

    public static String getFirstInvalidLabelCharacter(String name) {
        return BambooStringUtils.getFirstRelatedCharacter((String)name, (char[])INVALID_CHARACTERS);
    }

    @NotNull
    public static List<String> split(String input) {
        LinkedList result = TextUtils.stringSet((String)input) ? Lists.newLinkedList((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)LABEL_DELIM_CHARS)).trimResults().omitEmptyStrings().split((CharSequence)input)) : Collections.emptyList();
        return result;
    }

    @NotNull
    public static String replaceInvalidCharacters(@NotNull String label, @NotNull String replacement) {
        return label.replaceAll(INVALID_CHARACTERS_FIND_EXPR, replacement);
    }

    @NotNull
    public static List<Label> extractLabelsFromLabellings(@Nullable List<Labelling> labellings) {
        LinkedList<Label> labels = new LinkedList<Label>();
        if (labellings != null) {
            for (Labelling labelling : labellings) {
                labels.add(labelling.getLabel());
            }
        }
        return labels;
    }

    @NotNull
    public static String renderLabels(@NotNull Collection<Label> labels) {
        StringBuilder buffer = new StringBuilder(20);
        String sep = "";
        for (Label label : labels) {
            buffer.append(sep).append(label.getName());
            sep = LABEL_DELIM;
        }
        return buffer.toString().trim();
    }
}

