/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.log;

import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.setup.BambooHomeLocator;
import com.atlassian.config.HomeLocator;
import java.io.File;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.RollingFileAppender;

public class BambooRollingFileAppender
extends RollingFileAppender {
    private static HomeLocator externalHomeLocator;

    public void setFile(String file) {
        File fileObject = new File(file);
        if (!fileObject.isAbsolute()) {
            String homePath = this.getLocator().getHomePath();
            if (homePath != null) {
                super.setFile(homePath + File.separator + SystemDirectory.getLogRelativePath(file));
            } else {
                super.setFile(file);
            }
        } else {
            super.setFile(file);
        }
    }

    private HomeLocator getLocator() {
        return (HomeLocator)ObjectUtils.defaultIfNull((Object)externalHomeLocator, (Object)((Object)HomeLocatorImpl.INSTANCE));
    }

    public static void setExternalHomeLocator(HomeLocator externalHomeLocator) {
        BambooRollingFileAppender.externalHomeLocator = externalHomeLocator;
    }

    public static class HomeLocatorImpl
    extends BambooHomeLocator {
        private static final String PROP_FILE = "bamboo-init.properties";
        private static final String CFG_FILE = "bamboo.cfg.xml";
        public static HomeLocatorImpl INSTANCE = new HomeLocatorImpl();

        private HomeLocatorImpl() {
            this(PROP_FILE, "bamboo.home", CFG_FILE);
        }

        public HomeLocatorImpl(String propFile, String initPropertyName, String cfgFile) {
            this.setPropertiesFile(propFile);
            this.setInitPropertyName(initPropertyName);
            this.setConfigFileName(cfgFile);
        }
    }
}

