/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.logger.ErrorAccessor;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AggregatedChainErrorAccessor
implements ErrorAccessor {
    private static final Logger log = Logger.getLogger(AggregatedChainErrorAccessor.class);
    private final CachedPlanManager cachedPlanManager;
    private final ErrorAccessor errorAccessor;
    private final ResultsSummaryManager resultsSummaryManager;

    public AggregatedChainErrorAccessor(CachedPlanManager cachedPlanManager, ErrorAccessor errorAccessor, ResultsSummaryManager resultsSummaryManager) {
        this.cachedPlanManager = cachedPlanManager;
        this.errorAccessor = errorAccessor;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    @NotNull
    public Collection<ErrorDetails> getAllErrors() {
        return this.errorAccessor.getAllErrors();
    }

    @NotNull
    public Collection<ErrorDetails> getElasticErrors() {
        return this.errorAccessor.getElasticErrors();
    }

    @NotNull
    public Collection<ErrorDetails> getErrors(@NotNull ResultKey resultKey) {
        PlanResultKey planResultKey = (PlanResultKey)Narrow.to((Object)resultKey, PlanResultKey.class);
        if (planResultKey != null) {
            ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey, ChainResultsSummary.class);
            if (chainResultsSummary == null) {
                throw new IllegalArgumentException("Could not find ChainResultSummary with provided key '" + planResultKey + "'");
            }
            LinkedList<ErrorDetails> errors = new LinkedList<ErrorDetails>();
            errors.addAll(this.errorAccessor.getErrors((ResultKey)chainResultsSummary.getPlanResultKey()));
            for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
                for (BuildResultsSummary buildResultsSummary : chainStageResult.getBuildResults()) {
                    errors.addAll(this.errorAccessor.getErrors((ResultKey)buildResultsSummary.getPlanResultKey()));
                }
            }
            return errors;
        }
        throw new IllegalArgumentException("Cannot use the chain error access for with non Plan Keys.");
    }

    @NotNull
    public Collection<ErrorDetails> getErrors(@NotNull Key key) {
        PlanKey planKey = (PlanKey)Narrow.to((Object)key, PlanKey.class);
        if (planKey != null) {
            ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKey(planKey, ImmutableChain.class);
            if (chain == null) {
                throw new IllegalArgumentException("Could not find Plan with provided key '" + planKey + "'");
            }
            LinkedList<ErrorDetails> errors = new LinkedList<ErrorDetails>();
            errors.addAll(this.errorAccessor.getErrors((Key)chain.getPlanKey()));
            for (ImmutableJob job : chain.getAllJobs()) {
                errors.addAll(this.errorAccessor.getErrors((Key)job.getPlanKey()));
            }
            return errors;
        }
        throw new IllegalArgumentException("Cannot use the chain error access for with non Plan Keys.");
    }

    @NotNull
    public Collection<ErrorDetails> getErrorsByAgentId(Long agentId) {
        return this.errorAccessor.getErrorsByAgentId(agentId);
    }
}

