/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.logger.ElasticErrorDetailsImpl;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.logger.ThrowableDetails;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecoratedErrorDetailsImpl
implements ErrorDetails {
    private final ErrorDetails errorDetails;
    private final String planName;
    private final PlanKey parentPlanKey;
    private final boolean buildResultExists;
    private final boolean chainBranch;
    private final Supplier<List<BuildAgent>> agents = Lazy.supplier((Supplier)new Supplier<List<BuildAgent>>(){

        @Override
        public List<BuildAgent> get() {
            return DecoratedErrorDetailsImpl.this.getAgentIds().stream().map(input -> DecoratedErrorDetailsImpl.this.agentManager.getAgent(((Long)Preconditions.checkNotNull((Object)input)).longValue())).filter(Objects::nonNull).collect(Collectors.toList());
        }
    });
    private final Supplier<List<AgentIdentifier>> agentIdentifiers = Lazy.supplier((Supplier)new Supplier<List<AgentIdentifier>>(){

        @Override
        public List<AgentIdentifier> get() {
            return DecoratedErrorDetailsImpl.this.getAgentIds().stream().map(arg_0 -> AgentIdentifier.fromId(DecoratedErrorDetailsImpl.this.agentManager).apply(arg_0)).collect(Collectors.toList());
        }
    });
    private final Supplier<PartialVcsRepositoryData> repository = Lazy.supplier((Supplier)new Supplier<PartialVcsRepositoryData>(){

        @Override
        public PartialVcsRepositoryData get() {
            Long repositoryId = DecoratedErrorDetailsImpl.this.errorDetails.getThrowableDetails().getRepositoryId();
            if (repositoryId != null) {
                return DecoratedErrorDetailsImpl.this.repositoryDefinitionManager.getVcsRepositoryDataForEditing(repositoryId.longValue());
            }
            return null;
        }
    });
    private final AgentManager agentManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;

    public DecoratedErrorDetailsImpl(@NotNull ErrorDetails errorDetails, @NotNull AgentManager agentManager, @NotNull CachedPlanManager cachedPlanManager, @NotNull ResultsSummaryManager resultsSummaryManager, @NotNull RepositoryDefinitionManager repositoryDefinitionManager, @NotNull CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager) {
        ResultsSummary resultsSummary;
        this.errorDetails = errorDetails;
        this.agentManager = agentManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.cachedRepositoryDefinitionManager = cachedRepositoryDefinitionManager;
        PlanKey planKey = (PlanKey)Narrow.downTo((Object)errorDetails.getEntityKey(), PlanKey.class);
        if (planKey != null) {
            ImmutablePlan plan = cachedPlanManager.getPlanByKey(planKey);
            this.chainBranch = plan != null ? plan.hasMaster() : false;
            this.parentPlanKey = PlanClassHelper.isJob((ImmutablePlan)plan) ? PlanKeys.getChainKeyFromJobKey((PlanKey)planKey) : planKey;
            this.planName = plan != null ? plan.getName() : planKey.getKey();
        } else {
            this.parentPlanKey = null;
            this.planName = null;
            this.chainBranch = false;
        }
        PlanResultKey planResultKey = (PlanResultKey)Narrow.downTo((Object)errorDetails.getResultKey(), PlanResultKey.class);
        this.buildResultExists = planResultKey != null ? (resultsSummary = resultsSummaryManager.getResultsSummary(planResultKey)) != null : false;
    }

    @Nullable
    public String getBuildKey() {
        return this.errorDetails.getBuildKey();
    }

    @Nullable
    public Key getEntityKey() {
        return this.errorDetails.getEntityKey();
    }

    @Nullable
    public Integer getBuildNumber() {
        return this.errorDetails.getResultNumber();
    }

    @Nullable
    public Integer getResultNumber() {
        return this.errorDetails.getResultNumber();
    }

    @Nullable
    public Long getResultNumberLong() {
        return this.errorDetails.getResultNumberLong();
    }

    public boolean isBuildSpecific() {
        return this.errorDetails.isBuildSpecific();
    }

    public int getErrorNumber() {
        return this.errorDetails.getErrorNumber();
    }

    public String getBuildResultKey() {
        return this.errorDetails.getBuildResultKey();
    }

    @Nullable
    public ResultKey getResultKey() {
        return this.errorDetails.getResultKey();
    }

    @NotNull
    public Date getFirstOccurred() {
        return this.errorDetails.getFirstOccurred();
    }

    @NotNull
    public Date getLastOccurred() {
        return this.errorDetails.getLastOccurred();
    }

    public Set<Long> getAgentIds() {
        return this.errorDetails.getAgentIds();
    }

    public String getContext() {
        return this.errorDetails.getContext();
    }

    public int getNumberOfOccurrences() {
        return this.errorDetails.getNumberOfOccurrences();
    }

    @Nullable
    public ThrowableDetails getThrowableDetails() {
        return this.errorDetails.getThrowableDetails();
    }

    public List<BuildAgent> getAgents() {
        return this.agents.get();
    }

    public String getBuildName() {
        return this.planName;
    }

    public PlanKey getParentPlanKey() {
        return this.parentPlanKey;
    }

    public boolean isBuildExists() {
        return this.buildResultExists;
    }

    public boolean isElastic() {
        return this.errorDetails instanceof ElasticErrorDetailsImpl;
    }

    public List<String> getInstanceIds() {
        ElasticErrorDetailsImpl elasticErrorDetails = (ElasticErrorDetailsImpl)Narrow.downTo((Object)this.errorDetails, ElasticErrorDetailsImpl.class);
        return elasticErrorDetails != null ? elasticErrorDetails.getInstanceIds() : Collections.emptyList();
    }

    public List<AgentIdentifier> getAgentIdentifiers() {
        return this.agentIdentifiers.get();
    }

    public PartialVcsRepositoryData getRepositoryData() {
        return this.repository.get();
    }

    public VcsRepositoryData getRootRepository() {
        PartialVcsRepositoryData repositoryData = this.repository.get();
        return repositoryData != null ? this.cachedRepositoryDefinitionManager.getVcsRepositoryData(repositoryData.getRootVcsRepositoryId()) : null;
    }

    public RepositoryLevel getRepositoryLocationDefinitionLevel() {
        PartialVcsRepositoryData repositoryData = this.repository.get();
        if (repositoryData == null) {
            return this.isChainBranch() ? RepositoryLevel.BRANCH : RepositoryLevel.PLAN;
        }
        if (repositoryData.overridesLocation() && this.isChainBranch()) {
            return RepositoryLevel.BRANCH;
        }
        if (repositoryData.overridesLocation() || !repositoryData.isRootVcsLinked()) {
            return RepositoryLevel.PLAN;
        }
        return RepositoryLevel.LINKED;
    }

    public boolean isChainBranch() {
        return this.chainBranch;
    }

    public static class RepositoryIdentifier {
        private long repositoryId;
        private boolean shared;

        public RepositoryIdentifier(long repositoryId, boolean shared) {
            this.repositoryId = repositoryId;
            this.shared = shared;
        }

        public long getRepositoryId() {
            return this.repositoryId;
        }

        public boolean isShared() {
            return this.shared;
        }
    }

    public static class AgentIdentifier {
        private String name;
        private final long id;

        private AgentIdentifier(long id) {
            this.id = id;
        }

        private AgentIdentifier(BuildAgent agent) {
            this.id = agent.getId();
            this.name = agent.getName();
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public static Function<Long, AgentIdentifier> fromId(@NotNull AgentManager agentManager) {
            return input -> {
                BuildAgent agent = agentManager.getAgent((input = (Long)Preconditions.checkNotNull((Object)input)).longValue());
                return agent != null ? new AgentIdentifier(agent) : new AgentIdentifier((long)input);
            };
        }
    }

    public static enum RepositoryLevel {
        LINKED,
        PLAN,
        BRANCH;

    }
}

