/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.logger.DecoratedErrorDetailsFactory;
import com.atlassian.bamboo.logger.DecoratedErrorDetailsImpl;
import com.atlassian.bamboo.logger.ErrorAccessor;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DecoratingErrorAccessorImpl
implements ErrorAccessor {
    private static final Logger log = Logger.getLogger(DecoratingErrorAccessorImpl.class);
    private final DecoratedErrorDetailsFactory decoratedErrorDetailsFactory;
    private final ErrorAccessor errorAccessor;

    public DecoratingErrorAccessorImpl(DecoratedErrorDetailsFactory decoratedErrorDetailsFactory, ErrorAccessor errorAccessor) {
        this.decoratedErrorDetailsFactory = decoratedErrorDetailsFactory;
        this.errorAccessor = errorAccessor;
    }

    @NotNull
    public Collection<ErrorDetails> getAllErrors() {
        return Lists.newLinkedList(this.decorate(this.errorAccessor.getAllErrors()));
    }

    @NotNull
    public Collection<ErrorDetails> getElasticErrors() {
        return Lists.newLinkedList(this.decorate(this.errorAccessor.getElasticErrors()));
    }

    @NotNull
    public Collection<ErrorDetails> getErrors(@NotNull ResultKey resultKey) {
        return Lists.newLinkedList(this.decorate(this.errorAccessor.getErrors(resultKey)));
    }

    @NotNull
    public Collection<ErrorDetails> getErrors(@NotNull Key entityKey) {
        return Lists.newLinkedList(this.decorate(this.errorAccessor.getErrors(entityKey)));
    }

    @NotNull
    public Collection<ErrorDetails> getErrorsByAgentId(Long agentId) {
        return Lists.newLinkedList(this.decorate(this.errorAccessor.getErrorsByAgentId(agentId)));
    }

    @NotNull
    private Iterable<DecoratedErrorDetailsImpl> decorate(@NotNull Iterable<ErrorDetails> errors) {
        return Iterables.transform(errors, this.decoratedErrorDetailsFactory.decorator());
    }
}

