/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.event.BambooErrorEvent;
import com.atlassian.bamboo.logger.AbstractErrorUpdateHandler;
import com.atlassian.bamboo.logger.ElasticErrorDetailsImpl;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.logger.ErrorDetailsImpl;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.logger.ThrowableDetails;
import com.atlassian.bamboo.util.BambooMaps;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultErrorHandler
extends AbstractErrorUpdateHandler
implements ErrorHandler {
    private static final Logger log = Logger.getLogger(DefaultErrorHandler.class);
    private static final int DEFAULT_QUEUE_SIZE = 20;
    private static final int ELASTIC_ERROR_LIMIT = 20;
    private final AtomicInteger nextErrorNumber = new AtomicInteger();
    private final CopyOnWriteMap<String, Map<String, ErrorDetails>> errors = CopyOnWriteMap.builder().newHashMap();
    private volatile int maxQueueSize = 20;
    private final EventPublisher eventPublisher;

    public DefaultErrorHandler(AgentContext agentContext, EventPublisher eventPublisher) {
        super(agentContext);
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createElasticError(String context, @Nullable Long agentId, @Nullable ThrowableDetails throwableDetails, @Nullable String instanceId) {
        Map<String, ErrorDetails> errorMap;
        Date timeStamp = new Date();
        if (log.isDebugEnabled()) {
            if (throwableDetails != null) {
                log.debug((Object)("Recording an error: " + context + " : " + throwableDetails.getStackTrace()));
            } else {
                log.debug((Object)("Recording an error: " + context));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Recording an error: " + context));
        }
        String key = this.generateKey(context, throwableDetails);
        Map<String, ErrorDetails> map = errorMap = this.getBuildErrorMap("Elastic Bamboo");
        synchronized (map) {
            ErrorDetails errorDetails = errorMap.get(key);
            if (errorDetails != null) {
                if (errorDetails instanceof ErrorDetailsImpl) {
                    ((ErrorDetailsImpl)errorDetails).recordOccurrence(timeStamp, null, agentId);
                }
                if (errorDetails instanceof ElasticErrorDetailsImpl) {
                    ((ElasticErrorDetailsImpl)errorDetails).addInstance(instanceId);
                }
                this.eventPublisher.publish((Object)new BambooErrorEvent((Object)this, errorDetails, false));
            } else {
                errorMap.put(key, new ElasticErrorDetailsImpl(this.nextErrorNumber.getAndIncrement(), agentId, instanceId, context, timeStamp, throwableDetails));
                this.eventPublisher.publish((Object)new BambooErrorEvent((Object)this, errorMap.get(key), true));
            }
        }
    }

    public void createError(@Nullable String entityKey, Integer resultNumber, Long agentId, String context, ThrowableDetails throwableDetails) {
        this.createError(entityKey, resultNumber != null ? Long.valueOf(resultNumber.longValue()) : null, agentId, context, throwableDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createError(@Nullable String entityKey, Long resultNumber, Long agentId, String context, ThrowableDetails throwableDetails) {
        Map<String, ErrorDetails> errorMap;
        if (entityKey == null) {
            entityKey = "All Builds";
        }
        Date timeStamp = new Date();
        if (log.isInfoEnabled()) {
            if (throwableDetails != null) {
                String stacktrace = log.isDebugEnabled() ? SystemUtils.LINE_SEPARATOR + throwableDetails.getStackTrace() : " : " + throwableDetails.getMessage();
                log.info((Object)("Recording an error: " + context + " : " + entityKey + stacktrace));
            } else {
                log.info((Object)("Recording an error: " + context + " : " + entityKey));
            }
        }
        String key = this.generateKey(context, throwableDetails);
        Map<String, ErrorDetails> map = errorMap = this.getBuildErrorMap(entityKey);
        synchronized (map) {
            ErrorDetails errorDetails = errorMap.get(key);
            if (errorDetails != null) {
                if (errorDetails instanceof ErrorDetailsImpl) {
                    ((ErrorDetailsImpl)errorDetails).recordOccurrence(timeStamp, resultNumber, agentId);
                }
                this.eventPublisher.publish((Object)new BambooErrorEvent((Object)this, errorDetails, false));
            } else {
                errorMap.put(key, new ErrorDetailsImpl(this.nextErrorNumber.getAndIncrement(), entityKey, resultNumber, agentId, context, timeStamp, throwableDetails));
                this.eventPublisher.publish((Object)new BambooErrorEvent((Object)this, errorMap.get(key), true));
            }
        }
    }

    private Map<String, ErrorDetails> getBuildErrorMap(String key) {
        Map<String, ErrorDetails> newBuildErrorMap;
        Map existingBuildErrorMap = (Map)this.errors.get((Object)key);
        if (existingBuildErrorMap == null && (existingBuildErrorMap = (Map)this.errors.putIfAbsent((Object)key, newBuildErrorMap = BambooMaps.newLinkedHashMapWithLimitedSize(this.getErrorMapSize(key)))) == null) {
            return newBuildErrorMap;
        }
        return existingBuildErrorMap;
    }

    private int getErrorMapSize(String key) {
        return "Elastic Bamboo".equals(key) ? 20 : this.maxQueueSize;
    }

    private String generateKey(String context, @Nullable ThrowableDetails throwableDetails) {
        if (throwableDetails == null) {
            return context;
        }
        return context + ':' + throwableDetails.getName() + ':' + throwableDetails.getMessage();
    }

    @NotNull
    public Collection<ErrorDetails> getErrors(@NotNull ResultKey resultKey) {
        return this.getErrors(resultKey.getEntityKey()).stream().filter(this.errorOfPlanResult(resultKey)).collect(Collectors.toCollection(LinkedList::new));
    }

    @NotNull
    public Collection<ErrorDetails> getErrors(@NotNull Key planKey) {
        return this.getBuildErrorMap(planKey.getKey()).values();
    }

    @NotNull
    public Collection<ErrorDetails> getAllErrors() {
        LinkedList<ErrorDetails> allErrors = new LinkedList<ErrorDetails>();
        for (Map buildErrors : this.errors.values()) {
            allErrors.addAll(buildErrors.values());
        }
        return allErrors;
    }

    @NotNull
    public Collection<ErrorDetails> getErrorsByAgentId(Long agentId) {
        return this.getAllErrors().stream().filter(errorDetails -> errorDetails.getAgentIds().contains(agentId)).sorted(Comparator.comparing(ErrorDetails::getLastOccurred).reversed()).collect(Collectors.toList());
    }

    @NotNull
    public Collection<ErrorDetails> getElasticErrors() {
        return this.getBuildErrorMap("Elastic Bamboo").values();
    }

    public void clear() {
        this.errors.clear();
    }

    public void removeError(String buildKey, int errorNumber) {
        Iterator<ErrorDetails> iterator = this.getBuildErrorMap(buildKey).values().iterator();
        while (iterator.hasNext()) {
            ErrorDetails errorDetails = iterator.next();
            if (errorDetails.getErrorNumber() != errorNumber) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException("Cannot remove error from queue: error " + errorNumber + " does not exist");
    }

    public ErrorDetails getErrorDetails(String buildKey, int errorNumber) {
        for (ErrorDetails errorDetails : this.getBuildErrorMap(buildKey).values()) {
            if (errorDetails.getErrorNumber() != errorNumber) continue;
            return errorDetails;
        }
        throw new IllegalArgumentException("Cannot obtain error from queue: error " + errorNumber + " does not exist");
    }

    public void removeBuildErrors(String buildKey) {
        this.errors.remove((Object)buildKey);
    }

    @VisibleForTesting
    void setMaxQueueSize(int queueSize) {
        this.maxQueueSize = queueSize;
    }

    private Predicate<ErrorDetails> errorOfPlanResult(ResultKey resultKey) {
        return errorDetails -> {
            Integer errorDetailsResultNumber = errorDetails.getResultNumber();
            return errorDetailsResultNumber != null && errorDetailsResultNumber.longValue() == resultKey.getResultNumberLong();
        };
    }
}

