/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.logger.ErrorDetailsImpl;
import com.atlassian.bamboo.logger.ThrowableDetails;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.Nullable;

public class ElasticErrorDetailsImpl
extends ErrorDetailsImpl {
    public static final String ELASTIC_BAMBOO = "Elastic Bamboo";
    @GuardedBy(value="this")
    private final List<String> instanceIds = new CopyOnWriteArrayList<String>();

    public ElasticErrorDetailsImpl(int errorNumber, @Nullable Long agentId, @Nullable String instanceId, String context, Date timeStamp, ThrowableDetails throwableDetails) {
        super(errorNumber, ELASTIC_BAMBOO, (Long)null, agentId, context, timeStamp, throwableDetails);
        if (instanceId != null) {
            this.instanceIds.add(instanceId);
        }
    }

    @Override
    public boolean isBuildSpecific() {
        return false;
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    public synchronized List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public synchronized void addInstance(String instanceId) {
        if (instanceId != null) {
            this.instanceIds.add(instanceId);
        }
    }
}

