/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.logger.ThrowableDetails;
import com.atlassian.bamboo.plan.PlanKeys;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDetailsImpl
implements ErrorDetails {
    private static final Logger log = Logger.getLogger(ErrorDetailsImpl.class);
    public static final String ALL_BUILDS = "All Builds";
    private final int errorNumber;
    private final String buildKey;
    private final String context;
    private final ThrowableDetails throwableDetails;
    private final Date firstOccurred;
    @GuardedBy(value="this")
    private final Set<Long> agentIds = new LinkedHashSet<Long>();
    private volatile Date lastOccurred;
    private volatile Long resultNumber;
    private volatile int numberOfOccurrences = 1;

    public ErrorDetailsImpl(int errorNumber, String planKey, Long resultNumber, @Nullable Long agentId, String context, @Nullable Date timeStamp, @Nullable ThrowableDetails throwableDetails) {
        this.errorNumber = errorNumber;
        this.buildKey = planKey;
        this.context = context;
        this.throwableDetails = throwableDetails;
        if (timeStamp == null) {
            timeStamp = new Date();
        }
        this.firstOccurred = timeStamp;
        this.lastOccurred = timeStamp;
        this.resultNumber = resultNumber;
        if (agentId != null) {
            this.agentIds.add(agentId);
        }
    }

    public ErrorDetailsImpl(int errorNumber, String planKey, Integer resultNumber, @Nullable Long agentId, String context, @Nullable Date timeStamp, @Nullable ThrowableDetails throwableDetails) {
        this(errorNumber, planKey, resultNumber != null ? Long.valueOf(resultNumber.longValue()) : null, agentId, context, timeStamp, throwableDetails);
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }

    @Deprecated
    public String getBuildKey() {
        return this.buildKey;
    }

    @Nullable
    public Key getEntityKey() {
        return this.isBuildSpecific() ? PlanKeys.getPlanKey((String)this.buildKey) : null;
    }

    @Deprecated
    public String getBuildResultKey() {
        return this.buildKey + "-" + this.resultNumber;
    }

    @Nullable
    public ResultKey getResultKey() {
        return this.isBuildSpecific() && this.resultNumber != null ? PlanKeys.getPlanResultKey((String)this.buildKey, (int)this.resultNumber.intValue()) : null;
    }

    public synchronized Set<Long> getAgentIds() {
        return this.agentIds;
    }

    @Deprecated
    public Integer getBuildNumber() {
        return this.getResultNumber();
    }

    @Nullable
    public Integer getResultNumber() {
        return this.resultNumber != null ? Integer.valueOf(this.resultNumber.intValue()) : null;
    }

    @Nullable
    public Long getResultNumberLong() {
        return this.resultNumber;
    }

    public String getContext() {
        return this.context;
    }

    @NotNull
    public Date getLastOccurred() {
        return this.lastOccurred;
    }

    @NotNull
    public Date getFirstOccurred() {
        return this.firstOccurred;
    }

    public int getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    @Nullable
    public ThrowableDetails getThrowableDetails() {
        return this.throwableDetails;
    }

    public boolean isBuildSpecific() {
        return !ALL_BUILDS.equals(this.buildKey) && this.buildKey != null;
    }

    public boolean isElastic() {
        return false;
    }

    synchronized void recordOccurrence(Date timeStamp, Long resultNumber, Long agentId) {
        ++this.numberOfOccurrences;
        if (agentId != null) {
            this.agentIds.add(agentId);
        }
        if (timeStamp != null && (this.lastOccurred == null || timeStamp.after(this.lastOccurred))) {
            this.lastOccurred = timeStamp;
        }
        if (resultNumber != null && (this.resultNumber == null || resultNumber > this.resultNumber)) {
            this.resultNumber = resultNumber;
        }
    }
}

