/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.mail;

import com.atlassian.bamboo.mail.SMTPMailServerWithEncryptedPassword;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.core.util.Dom4jUtil;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.managers.XMLMailServerManager;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BambooMailServerManager
extends XMLMailServerManager {
    private static final Logger log = Logger.getLogger(BambooMailServerManager.class);

    protected InputStream getConfigurationInputStream(String resource) {
        try {
            String applicationHome = BootstrapUtils.getBootstrapManager().getApplicationHome();
            File file = new File(applicationHome, resource);
            if (!file.exists() || !file.isFile()) {
                Document doc = DocumentHelper.createDocument();
                Element root = doc.addElement("mail-servers");
                this.saveXmlDocument(doc);
                file = new File(applicationHome, resource);
            }
            return new FileInputStream(file);
        }
        catch (Exception e) {
            return super.getConfigurationInputStream(resource);
        }
    }

    public void delete(Long mailServerId) throws MailException {
        super.delete(mailServerId);
        this.refresh();
    }

    public void update(MailServer mailServer) throws MailException {
        super.update(mailServer);
        this.refresh();
    }

    private void refresh() throws MailException {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("mail-servers");
        for (SMTPMailServer smtpMailServer : this.getSmtpMailServers()) {
            this.addMailServerXml(root, (MailServer)smtpMailServer);
        }
        for (PopMailServer popMailServer : this.getPopMailServers()) {
            this.addMailServerXml(root, (MailServer)popMailServer);
        }
        this.saveXmlDocument(doc);
    }

    private void addMailServerXml(Element root, MailServer mailServer) {
        Element smtpServerElem = root.addElement("smtp-server");
        smtpServerElem.addElement("name").setText(mailServer.getName());
        if (mailServer.getDescription() != null) {
            smtpServerElem.addElement("description").setText(mailServer.getDescription());
        }
        if (mailServer.getUsername() != null) {
            smtpServerElem.addElement("username").setText(mailServer.getUsername());
        }
        if (mailServer.getPassword() != null) {
            smtpServerElem.addElement("password").setText(mailServer.getPassword());
        }
        if (mailServer instanceof SMTPMailServer) {
            String jndiLocation;
            String host;
            String prefix;
            SMTPMailServer smtpMailServer = (SMTPMailServer)mailServer;
            String from = smtpMailServer.getDefaultFrom();
            if (from != null) {
                smtpServerElem.addElement("defaultFrom").setText(from);
            }
            if ((prefix = smtpMailServer.getPrefix()) != null) {
                smtpServerElem.addElement("prefix").setText(prefix);
            }
            if (smtpMailServer.isRemovePrecedence()) {
                smtpServerElem.addElement("removePrecedence").setText("true");
            }
            if (TextUtils.stringSet((String)(host = smtpMailServer.getHostname()))) {
                smtpServerElem.addElement("hostname").setText(host);
                smtpServerElem.addElement("sessionServer").setText("false");
                String smtpPort = smtpMailServer.getPort();
                if (smtpPort != null) {
                    smtpServerElem.addElement("port").setText(smtpPort);
                }
                smtpServerElem.addElement("tlsRequired").setText(Boolean.toString(smtpMailServer.isTlsRequired()));
            }
            if (TextUtils.stringSet((String)(jndiLocation = smtpMailServer.getJndiLocation()))) {
                smtpServerElem.addElement("jndi-location").setText(smtpMailServer.getJndiLocation());
                smtpServerElem.addElement("sessionServer").setText("true");
            }
        }
    }

    private void saveXmlDocument(Document doc) throws MailException {
        File bambooHomeDir = new File(BootstrapUtils.getBootstrapManager().getApplicationHome());
        try {
            if (!bambooHomeDir.exists() && !bambooHomeDir.mkdirs()) {
                log.error((Object)"Error creating 'config' directory under bamboo home.");
            }
            Dom4jUtil.saveDocumentTo((Document)doc, (String)bambooHomeDir.getAbsolutePath(), (String)this.getConfigFile());
        }
        catch (IOException e) {
            throw new MailException("Couldn't save " + this.getConfigFile() + " to " + bambooHomeDir.getAbsolutePath() + " directory.", (Throwable)e);
        }
    }

    protected Class getSMTPMailServerClass() {
        return SMTPMailServerWithEncryptedPassword.class;
    }

    protected Digester newDigester() {
        return BambooXmlUtils.newSecureDigester();
    }
}

