/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.mail;

import com.atlassian.bamboo.mail.EmailService;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.mail.Email;
import com.atlassian.mail.server.SMTPMailServer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class BambooMailer {
    private static final Logger log = Logger.getLogger(BambooMailer.class);
    private TemplateRenderer templateRenderer;
    private EmailService emailService;

    @Inject
    public BambooMailer(EmailService emailService) {
        this.emailService = emailService;
    }

    public void send(String template, Map context, List recipients, String subject) throws Exception {
        this.send(template, context, recipients, subject, null);
    }

    public void send(String template, Map context, List recipients, String subject, SMTPMailServer mailServer) throws Exception {
        if (template == null || "".equals(template.trim())) {
            throw new NullPointerException("template location must be specified");
        }
        if (context == null) {
            throw new NullPointerException("context must be specified");
        }
        if (recipients == null || recipients.isEmpty()) {
            throw new NullPointerException("There must be at least one recipient to the email");
        }
        String parsedResult = this.templateRenderer.render(template, context);
        Email email = new Email(this.reTokenize(recipients));
        email.setBody(parsedResult);
        email.setSubject(subject);
        email.setMimeType("text/plain");
        email.setFromName(null);
        if (mailServer == null) {
            this.emailService.queueEmail(email);
        } else {
            this.emailService.sendEmailSynchronously(email, mailServer);
        }
    }

    private String reTokenize(List buildChangedEmailsList) {
        if (buildChangedEmailsList == null || buildChangedEmailsList.isEmpty()) {
            return null;
        }
        StringBuilder appendedEmails = new StringBuilder();
        Iterator iterator = buildChangedEmailsList.iterator();
        while (iterator.hasNext()) {
            String email = (String)iterator.next();
            appendedEmails.append(email);
            if (!iterator.hasNext()) continue;
            appendedEmails.append(", ");
        }
        return appendedEmails.toString();
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }
}

