/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.mail;

import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    private static final String MAIL_THREAD_NAME = "mail-queue-processor";
    private static final Logger log = Logger.getLogger(EmailService.class);
    private final MailServerManager mailServerManager;
    @VisibleForTesting
    final BlockingQueue<Email> emailQueue;
    private Thread mailSendingThread;

    public EmailService(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
        int queueSize = (int)SystemProperty.MAIL_QUEUE_SIZE.getTypedValue();
        this.emailQueue = new LinkedBlockingDeque<Email>(queueSize);
    }

    @PostConstruct
    public void init() {
        this.initialiseMailQueueProcessor();
    }

    @PreDestroy
    public void onDestroy() {
        this.mailSendingThread.interrupt();
    }

    public boolean queueEmail(Email email) {
        boolean success = this.emailQueue.offer(email);
        if (!success) {
            log.warn((Object)("Failed to queue email - to: " + email.getTo() + ", subject: " + email.getSubject()));
        }
        return success;
    }

    public void emptyQueue() {
        this.emailQueue.clear();
    }

    public boolean isQueueEmpty() {
        return this.emailQueue.isEmpty();
    }

    protected MailQueueProcessor getMailQueueProcessor() {
        return new MailQueueProcessor();
    }

    private void initialiseMailQueueProcessor() {
        this.mailSendingThread = new Thread((Runnable)this.getMailQueueProcessor(), MAIL_THREAD_NAME);
        this.mailSendingThread.setDaemon(true);
        this.mailSendingThread.start();
    }

    public void sendEmailSynchronously(Email email, SMTPMailServer mailServer) throws MailException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending email to: " + email.getTo() + ", subject: " + email.getSubject()));
        }
        if (mailServer == null) {
            mailServer = this.mailServerManager.getDefaultSMTPMailServer();
        }
        if (mailServer == null) {
            return;
        }
        if (mailServer.isRemovePrecedence()) {
            email.removeHeader("Precedence");
        }
        if (email.getFromName() == null) {
            email.setFromName(mailServer.getName());
        }
        mailServer.send(email);
    }

    class MailQueueProcessor
    implements Runnable {
        MailQueueProcessor() {
        }

        @Override
        public void run() {
            log.info((Object)"Successfully initialised mail queue processor");
            while (true) {
                try {
                    while (true) {
                        EmailService.this.sendEmailSynchronously(EmailService.this.emailQueue.take(), null);
                    }
                }
                catch (InterruptedException ex) {
                    log.info((Object)"Shutting down mail sending thread");
                }
                catch (Exception ex) {
                    log.warn((Object)"Uncaught exception while processing mail queue", (Throwable)ex);
                    continue;
                }
                break;
            }
            if (!EmailService.this.emailQueue.isEmpty()) {
                log.warn((Object)("Mail queue processing terminated while mail is still in the queue.  " + EmailService.this.emailQueue.size() + " queued messages have been lost."));
            }
        }
    }
}

