/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.mail;

import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import org.apache.commons.lang3.StringUtils;

public class SMTPMailServerWithEncryptedPassword
extends SMTPMailServerImpl {
    public SMTPMailServerWithEncryptedPassword() {
        this.setMailProtocol(MailProtocol.SMTP);
    }

    public String getPort() {
        String port = super.getPort();
        if (StringUtils.isBlank((CharSequence)port)) {
            return "25";
        }
        return port;
    }

    protected Authenticator getAuthenticator() {
        return new EncryptedPasswordAuthenticator();
    }

    private class EncryptedPasswordAuthenticator
    extends Authenticator {
        private EncryptedPasswordAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(SMTPMailServerWithEncryptedPassword.this.getUsername(), this.getUnencryptedPassword());
        }

        private String getUnencryptedPassword() {
            return ((SecretEncryptionService)ComponentAccessor.SECRET_ENCRYPTION_SERVICE.get()).decrypt(SMTPMailServerWithEncryptedPassword.this.getPassword());
        }
    }
}

