/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.LegacyRepositoryDataImpl;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import com.atlassian.event.Event;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNotification
implements Notification,
Notification.HtmlImContentProvidingNotification {
    protected static final String NAVIGATION_SOURCE = "email";
    private static final Logger log = Logger.getLogger(AbstractNotification.class);
    private Object event;
    private Set<NotificationRecipient> recipients = new HashSet<NotificationRecipient>();
    private Set<NotificationRecipient> excludedRecipients = new HashSet<NotificationRecipient>();

    public void setEvent(@Nullable Event event) {
        this.event = event;
    }

    public void setEvent(@Nullable Object event) {
        this.event = event;
    }

    @Nullable
    public Event getEvent() {
        return (Event)this.event;
    }

    @Nullable
    public Object getPojoEvent() {
        return this.event;
    }

    @NotNull
    public Set<NotificationRecipient> getNotificationRecipients() {
        return this.recipients;
    }

    @NotNull
    public Set<NotificationRecipient> getExcludedNotificationRecipients() {
        return this.excludedRecipients;
    }

    public void setNotificationRecipients(@NotNull Set<NotificationRecipient> recipients) {
        this.recipients = recipients;
    }

    public void setExcludedNotificationRecipients(@NotNull Set<NotificationRecipient> recipients) {
        this.excludedRecipients = recipients;
    }

    public void addRecipient(@NotNull NotificationRecipient recipient) {
        this.recipients.add(recipient);
    }

    public void excludeRecipient(@NotNull NotificationRecipient recipient) {
        this.excludedRecipients.add(recipient);
    }

    @Deprecated
    public RepositoryData getRepositoryData(@Nullable RepositoryDataEntity entity) {
        if (BuildUtils.isDevMode()) {
            throw new UnsupportedOperationException("Do not use old repository data in notifications, pretty please");
        }
        if (entity != null) {
            return new LegacyRepositoryDataImpl(entity);
        }
        return null;
    }

    @Deprecated
    public RepositoryData getRepositoryData(@Nullable RepositoryChangeset repositoryChangeset) {
        if (BuildUtils.isDevMode()) {
            throw new UnsupportedOperationException("Do not use old repository data in notifications, pretty please");
        }
        if (repositoryChangeset == null) {
            return null;
        }
        RepositoryDataEntity entity = repositoryChangeset.getRepositoryData();
        return new LegacyRepositoryDataImpl(entity);
    }

    protected String getCommitUrl(@NotNull RepositoryDataEntity repositoryDataEntity, String revision, @NotNull ImmutablePlan plan, @NotNull CustomVariableContext customVariableContext, @NotNull RepositoryDefinitionManager repositoryDefinitionManager, @NotNull VcsRepositoryViewerManager vcsRepositoryViewerManager) {
        if (StringUtils.isBlank((CharSequence)revision)) {
            return "";
        }
        return (String)customVariableContext.withVariableSubstitutor(customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(plan), () -> {
            VcsRepositoryData vcsRepositoryData = repositoryDefinitionManager.getVcsRepositoryData(repositoryDataEntity.getId());
            if (vcsRepositoryData == null) {
                return "";
            }
            VcsRepositoryViewer vcsRepositoryViewer = vcsRepositoryViewerManager.getViewerForRepository(vcsRepositoryData);
            if (vcsRepositoryViewer == null) {
                return "";
            }
            return vcsRepositoryViewer.getWebRepositoryUrlForRevision(revision, vcsRepositoryData);
        });
    }

    public String getHtmlImContent() {
        return this.getIMContent();
    }

    public boolean applyDefaultCssStyles() {
        return true;
    }
}

