/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.event.BambooErrorEvent;
import com.atlassian.bamboo.event.HibernateEventListener;
import com.atlassian.bamboo.event.PlanEvent;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.notification.NotificationDispatcher;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.notification.SystemNotificationService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.event.Event;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNotificationEventListener<T extends Event>
implements HibernateEventListener {
    private static final Logger log = Logger.getLogger(AbstractNotificationEventListener.class);
    protected NotificationDispatcher notificationDispatcher;
    protected NotificationManager notificationManager;
    protected CachedPlanManager cachedPlanManager;
    protected SystemNotificationService systemNotificationService;
    protected final Class<T> eventClass;
    protected final Set<Class<? extends NotificationType>> notificationTypeFilter;

    protected AbstractNotificationEventListener(Class<T> eventClass, Set<Class<? extends NotificationType>> notificationTypeFilter) {
        this.eventClass = eventClass;
        this.notificationTypeFilter = notificationTypeFilter;
    }

    public Class<? extends Event>[] getHandledEventClasses() {
        return new Class[]{this.eventClass};
    }

    protected Iterable<NotificationRule> getNotificationRules(@NotNull ImmutablePlan plan, @NotNull T event) {
        return this.filterNotificationRules(this.notificationManager.getNotificationRules(plan), event);
    }

    protected Iterable<NotificationRule> getSystemNotificationRules(@NotNull T event) {
        return this.filterNotificationRules(this.systemNotificationService.getSystemNotificationRules(), event);
    }

    protected Iterable<NotificationRule> filterNotificationRules(@NotNull Iterable<NotificationRule> iterable, final @NotNull T event) {
        return Iterables.filter(iterable, (Predicate)new Predicate<NotificationRule>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply(@Nullable NotificationRule rule) {
                if (rule == null) return false;
                NotificationType notificationType = AbstractNotificationEventListener.this.notificationManager.getNotificationType(rule);
                if (notificationType == null) return false;
                if (!AbstractNotificationEventListener.this.notificationTypeFilter.stream().anyMatch(arg_0 -> BambooPredicates.isAssignableFrom(notificationType.getClass()).apply(arg_0))) return false;
                if (!AbstractNotificationEventListener.this.isNotificationRequired(notificationType, event)) return false;
                return true;
            }
        });
    }

    private boolean isNotificationRequired(NotificationType notificationType, T event) {
        return notificationType.isNotificationRequired(event);
    }

    public abstract void handleEvent(@NotNull T var1, @NotNull ImmutablePlan var2);

    public void handleEvent(Event event) {
        Event narrowedEvent = (Event)Narrow.to((Object)event, this.eventClass);
        if (narrowedEvent != null) {
            ImmutablePlan plan = this.getPlan(narrowedEvent);
            if (plan != null) {
                this.handleEvent(narrowedEvent, plan);
            } else {
                log.info((Object)("Could not find any plan matching the event " + event + ", no notifications will be sent."));
            }
        } else {
            log.info((Object)String.format("Event could not be narrowed to class '%s'", this.eventClass.getName()));
        }
    }

    @Nullable
    protected ImmutablePlan getPlan(@NotNull T event) {
        PlanKey planKey;
        ErrorDetails errorDetails;
        PlanEvent planEvent = (PlanEvent)Narrow.reinterpret(event, PlanEvent.class);
        if (planEvent != null) {
            return this.cachedPlanManager.getPlanByKey(planEvent.getPlanKey());
        }
        BambooErrorEvent bambooErrorEvent = (BambooErrorEvent)((Object)Narrow.reinterpret(event, BambooErrorEvent.class));
        if (bambooErrorEvent != null && (errorDetails = bambooErrorEvent.getErrorDetails()).isBuildSpecific() && (planKey = this.getPlanKeyQuietly(errorDetails.getBuildKey())) != null) {
            return this.cachedPlanManager.getPlanByKey(planKey);
        }
        return null;
    }

    @Nullable
    private PlanKey getPlanKeyQuietly(@Nullable String planKey) {
        if (planKey == null) {
            return null;
        }
        try {
            return PlanKeys.getPlanKey((String)planKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setNotificationDispatcher(NotificationDispatcher notificationDispatcher) {
        this.notificationDispatcher = notificationDispatcher;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setSystemNotificationService(SystemNotificationService systemNotificationService) {
        this.systemNotificationService = systemNotificationService;
    }
}

