/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.plugin.descriptor.NotificationTypeModuleDescriptor;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.plugin.web.descriptors.WeightedDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNotificationType
implements NotificationType {
    private static final Logger log = Logger.getLogger(AbstractNotificationType.class);
    protected NotificationTypeModuleDescriptor notificationTypeModuleDescriptor;

    public void setConfigurationData(@Nullable String data) {
    }

    public boolean isNotificationRequired(@NotNull Object event) {
        return false;
    }

    public void init(@NotNull WeightedDescriptor moduleDescriptor) {
        if (!(moduleDescriptor instanceof NotificationTypeModuleDescriptor)) {
            throw new IllegalArgumentException("Descriptor not of type " + NotificationTypeModuleDescriptor.class);
        }
        this.notificationTypeModuleDescriptor = (NotificationTypeModuleDescriptor)moduleDescriptor;
    }

    @Nullable
    public WeightedDescriptor getModuleDescriptor() {
        return this.notificationTypeModuleDescriptor;
    }

    @NotNull
    public String getKey() {
        return this.notificationTypeModuleDescriptor.getCompleteKey();
    }

    @NotNull
    public String getName() {
        return this.notificationTypeModuleDescriptor.getName();
    }

    @NotNull
    public String getDescription() {
        return this.notificationTypeModuleDescriptor.getDescription();
    }

    public NotificationType.Scope getScope() {
        return this.notificationTypeModuleDescriptor.getScope() == null ? NotificationType.Scope.PLAN : this.notificationTypeModuleDescriptor.getScope();
    }

    @NotNull
    public String getConfigurationData() {
        return "";
    }

    @NotNull
    public String getEditHtml() {
        return "";
    }

    @NotNull
    public String getViewHtml() {
        return "";
    }

    @NotNull
    public ErrorCollection validate(@NotNull Map<String, String[]> params) {
        return new SimpleErrorCollection();
    }

    public void populate(@NotNull Map<String, String[]> config) {
    }

    public int compareTo(Object o) {
        if (!(o instanceof NotificationType)) {
            return 1;
        }
        NotificationType type = (NotificationType)o;
        if (type.getModuleDescriptor() != null && this.getModuleDescriptor() != null) {
            WeightedDescriptorComparator comparator = new WeightedDescriptorComparator();
            return comparator.compare(this.getModuleDescriptor(), type.getModuleDescriptor());
        }
        return this.getKey().compareTo(type.getKey());
    }
}

