/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationDispatcher;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationTransport;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class NotificationDispatcherImpl
implements NotificationDispatcher {
    private static final Logger log = Logger.getLogger(NotificationDispatcherImpl.class);
    public static final String DISABLE_NOTIFICATION_SYSTEM_PROPERTY = "atlassian.mail.senddisabled";

    public void dispatchNotifications(Notification notification) {
        if (Boolean.parseBoolean(System.getProperty(DISABLE_NOTIFICATION_SYSTEM_PROPERTY))) {
            log.info((Object)"No notifications sent due to flag -Datlassian.mail.senddisabled=true");
            return;
        }
        if (notification == null || notification.getNotificationRecipients().isEmpty()) {
            return;
        }
        HashSet transports = new HashSet();
        for (NotificationRecipient recipient : notification.getNotificationRecipients()) {
            transports.addAll(recipient.getTransports());
        }
        for (NotificationRecipient excludedRecipient : notification.getExcludedNotificationRecipients()) {
            transports.removeAll(excludedRecipient.getTransports());
        }
        for (NotificationTransport transport : transports) {
            transport.sendNotification(notification);
        }
    }
}

