/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationFormatter;
import com.atlassian.bamboo.notification.recipients.UserRecipient;
import com.atlassian.bamboo.notification.recipients.UserRecipientImpl;
import com.atlassian.bamboo.notification.transports.ImTransport;
import com.atlassian.bamboo.notification.transports.MultipartEmailTransport;
import com.atlassian.bamboo.notification.transports.TextEmailTransport;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.xmpp.BambooSmackClient;
import com.atlassian.event.api.EventPublisher;
import org.apache.log4j.Logger;

public class NotificationFactoryImpl
implements NotificationFactory {
    private static final Logger log = Logger.getLogger(NotificationFactoryImpl.class);
    private BambooSmackClient bambooSmackClient;
    private EventPublisher eventPublisher;
    private BambooUserManager bambooUserManager;
    private TemplateRenderer templateRenderer;
    private PlanManager planManager;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private NotificationFormatter notificationFormatter;

    @Override
    public ImTransport getImTransport(String imAddress) {
        return new ImTransport(imAddress, this.bambooSmackClient, this.planManager);
    }

    @Override
    public TextEmailTransport getTextEmailTransport(String emailAddress) {
        return new TextEmailTransport(emailAddress, this.eventPublisher, this.administrationConfigurationAccessor);
    }

    @Override
    public MultipartEmailTransport getMultipartEmailTransport(String emailAddress) {
        return new MultipartEmailTransport(emailAddress, this.eventPublisher, this.notificationFormatter, this.administrationConfigurationAccessor);
    }

    @Override
    public UserRecipient getUserRecipient(String username) {
        UserRecipientImpl recipient = new UserRecipientImpl();
        recipient.setBambooUserManager(this.bambooUserManager);
        recipient.setNotificationFactory(this);
        recipient.setTemplateRenderer(this.templateRenderer);
        recipient.setUsername(username);
        return recipient;
    }

    public void setBambooSmackClient(BambooSmackClient bambooSmackClient) {
        this.bambooSmackClient = bambooSmackClient;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void setNotificationFormatter(NotificationFormatter notificationFormatter) {
        this.notificationFormatter = notificationFormatter;
    }
}

