/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.notification.NotificationFormatter;
import com.atlassian.botocss.Botocss;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class NotificationFormatterImpl
implements NotificationFormatter {
    private static final Logger log = LoggerFactory.getLogger(NotificationFormatterImpl.class);
    private static final Resource STYLESHEET = new ClassPathResource("/notification-templates/styles/notifications.css");
    @Nullable
    private final String css = this.loadCss(STYLESHEET);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String loadCss(Resource resource) {
        InputStream stream;
        try {
            stream = STYLESHEET.getInputStream();
        }
        catch (IOException e) {
            log.warn("Couldn't open stylesheet: " + resource);
            return null;
        }
        try {
            String e = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            return e;
        }
        catch (IOException e) {
            log.warn("Failed to read stylesheet: " + resource);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @NotNull
    public String applyStyles(@NotNull String html) {
        return Botocss.inject((String)html, (String[])new String[]{this.css});
    }
}

