/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.notification.NotificationDao;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationRuleImpl;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.notification.UsersNotification;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.descriptor.NotificationRecipientModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.NotificationTypeModuleDescriptor;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServerSideOnly
public class NotificationManagerImpl
implements NotificationManager {
    private static final Logger log = Logger.getLogger(NotificationManagerImpl.class);
    private static final String EMAIL_RECIPIENT = "com.atlassian.bamboo.plugin.system.notifications:recipient.email";
    private static final String IM_RECIPIENT = "com.atlassian.bamboo.plugin.system.notifications:recipient.im";
    private static final String GROUP_RECIPIENT = "com.atlassian.bamboo.plugin.system.notifications:recipient.group";
    public static final String USER_RECIPIENT = "com.atlassian.bamboo.plugin.system.notifications:recipient.user";
    public static final String COMMITTER_RECIPIENT = "com.atlassian.bamboo.plugin.system.notifications:recipient.committer";
    public static final String WATCHER_RECIPIENT = "com.atlassian.bamboo.plugin.system.notifications:recipient.watcher";
    public static final String FAILED_CHAIN_NOTIFICATION = "com.atlassian.bamboo.plugin.system.notifications:chainCompleted.failedChains";
    private NotificationDao notificationDao;
    private PluginAccessor pluginAccessor;
    @Inject
    private BambooUserManager bambooUserManager;
    private LabelManager labelManager;

    public void saveNotificationSet(NotificationSet notificationSet) {
        this.notificationDao.saveNotificationSet(notificationSet);
    }

    public NotificationRule createNotificationRule(String conditionKey, String conditionData, String recipientString, String recipientType) {
        NotificationRuleImpl newNR = new NotificationRuleImpl();
        newNR.setNotificationManager(this);
        newNR.setConditionData(conditionData);
        newNR.setConditionKey(conditionKey);
        newNR.setRecipient(recipientString);
        newNR.setRecipientType(recipientType);
        return newNR;
    }

    @NotNull
    public NotificationRule createNotificationRule(@NotNull Class<? extends NotificationType> notificationTypeClass, @Nullable String conditionData, @NotNull Class<? extends NotificationRecipient> recipientTypeClass, @Nullable String recipientString) {
        NotificationType notificationType = this.findUniqueModuleFromType(notificationTypeClass);
        NotificationRecipient notificationRecipient = this.findUniqueModuleFromType(recipientTypeClass);
        NotificationRuleImpl notificationRule = new NotificationRuleImpl();
        notificationRule.setNotificationManager(this);
        notificationRule.setConditionKey(notificationType.getKey());
        notificationRule.setConditionData(conditionData);
        notificationRule.setRecipientType(notificationRecipient.getKey());
        notificationRule.setRecipient(recipientString);
        return notificationRule;
    }

    @NotNull
    public NotificationRule createNotificationRuleFromAction(String notificationTypeKey, String notificationRecipientKey, Map<String, String[]> actionParams) throws IllegalArgumentException {
        NotificationType notificationType = this.getNotificationTypeFromKey(notificationTypeKey);
        if (notificationType == null) {
            throw new IllegalArgumentException("Can not create system notification, could not find matching notification type for key: " + notificationTypeKey);
        }
        notificationType.populate(actionParams);
        String configData = notificationType.getConfigurationData();
        NotificationRecipient recipient = this.getNotificationRecipientFromKey(notificationRecipientKey);
        if (recipient == null) {
            throw new IllegalArgumentException("Can not create system notification, could not find matching notification recipient for key: " + notificationRecipientKey);
        }
        recipient.populate(actionParams);
        return this.createNotificationRule(notificationTypeKey, configData, recipient.getRecipientConfig(), notificationRecipientKey);
    }

    @NotNull
    private <M> M findUniqueModuleFromType(@NotNull Class<M> clazz) {
        List modules = this.pluginAccessor.getEnabledModulesByClass(clazz);
        if (modules == null || modules.size() != 1) {
            throw new IllegalArgumentException("Cannot find unique module for module class '" + clazz + "' , " + (modules == null ? "No" : Integer.valueOf(modules.size())) + " modules found");
        }
        return (M)modules.get(0);
    }

    public Set<NotificationRule> getNotificationRules(@Nullable Plan plan) {
        return this.getNotificationRules((ImmutablePlan)plan);
    }

    @NotNull
    public Set<NotificationRule> getNotificationRules(@Nullable ImmutablePlan plan) {
        if (plan == null) {
            return Collections.emptySet();
        }
        ImmutableChain chain = (ImmutableChain)Narrow.downTo((Object)plan, ImmutableChain.class);
        if (chain != null) {
            NotificationSet notificationSet = chain.getNotificationSet();
            return notificationSet.getNotificationRules();
        }
        ImmutableJob job = (ImmutableJob)Narrow.to((Object)plan, ImmutableJob.class);
        if (job != null) {
            return this.getNotificationRules((ImmutablePlan)job.getParent()).stream().filter(this.notificationRuleScopePredicate(NotificationType.Scope.PLAN)).collect(Collectors.toSet());
        }
        log.info((Object)String.format("Plan '%s' is neither Chain nor Job", plan.getKey()));
        return Collections.emptySet();
    }

    public NotificationSet cloneNotificationSet(NotificationSet oldSet) {
        if (oldSet == null) {
            return null;
        }
        NotificationSetImpl newSet = new NotificationSetImpl();
        if (oldSet.getNotificationRules() != null) {
            for (NotificationRule oldRule : oldSet.getNotificationRules()) {
                NotificationRuleImpl newRule = new NotificationRuleImpl();
                newRule.setNotificationSet(newSet);
                newRule.setConditionKey(oldRule.getConditionKey());
                newRule.setConditionData(oldRule.getConditionData());
                newRule.setRecipient(oldRule.getRecipient());
                newRule.setRecipientType(oldRule.getRecipientType());
                newRule.setNotificationManager(this);
                newSet.addNotification(newRule);
            }
        }
        return newSet;
    }

    @NotNull
    public List<NotificationSet> getNotificationSetsForType(NotificationSet.NotificationSetType type) {
        return this.notificationDao.getNotificationSetsForType(type);
    }

    public List<NotificationType> getAllNotificationTypes() {
        return this.pluginAccessor.getEnabledModulesByClass(NotificationType.class);
    }

    private List<NotificationType> getNotificationTypes(Predicate<NotificationType> predicate) {
        return this.getAllNotificationTypes().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<NotificationType> getSystemNotificationTypes() {
        return this.getNotificationTypes(this.notificationTypePredicate(NotificationType.Scope.SYSTEM));
    }

    public List<NotificationType> getDeploymentNotificationTypes() {
        return this.getNotificationTypes(this.notificationTypePredicate(NotificationType.Scope.DEPLOYMENT));
    }

    public List<NotificationType> getPlanNotificationTypes() {
        return this.getNotificationTypes(this.notificationTypePredicate(NotificationType.Scope.PLAN));
    }

    public List<NotificationType> getChainNotificationTypes() {
        return this.getNotificationTypes(this.notificationTypePredicate(NotificationType.Scope.CHAIN));
    }

    public List<NotificationRecipient> getAllNotificationRecipients() {
        return this.pluginAccessor.getEnabledModulesByClass(NotificationRecipient.class);
    }

    public NotificationRecipient getNotificationRecipientFromKey(String notificationRecipientKey) {
        ModuleDescriptor descriptor = this.pluginAccessor.getEnabledPluginModule(notificationRecipientKey);
        if (descriptor instanceof NotificationRecipientModuleDescriptor) {
            return (NotificationRecipient)descriptor.getModule();
        }
        return null;
    }

    @Nullable
    public NotificationRecipient getNotificationRecipient(NotificationRule rule) {
        String recipientType = rule.getRecipientType();
        if (recipientType != null) {
            NotificationRecipient notificationRecipient = this.getNotificationRecipientFromKey(rule.getRecipientType());
            if (notificationRecipient != null) {
                notificationRecipient.init(rule.getRecipient());
            }
            return notificationRecipient;
        }
        return null;
    }

    @Nullable
    public NotificationType getNotificationType(NotificationRule rule) {
        String conditionKey = rule.getConditionKey();
        if (conditionKey != null) {
            NotificationType notificationType = this.getNotificationTypeFromKey(conditionKey);
            if (notificationType != null) {
                notificationType.setConfigurationData(rule.getConditionData());
            }
            return notificationType;
        }
        return null;
    }

    @Nullable
    public NotificationType getNotificationTypeFromKey(String key) {
        ModuleDescriptor descriptor = this.pluginAccessor.getEnabledPluginModule(key);
        if (descriptor instanceof NotificationTypeModuleDescriptor) {
            return (NotificationType)descriptor.getModule();
        }
        return null;
    }

    @NotNull
    public List<UsersNotification> getNotificationRulesForUser(@NotNull BambooUser user) {
        ArrayList<UsersNotification> rules = new ArrayList<UsersNotification>();
        String username = user.getUsername();
        String jabberAddress = user.getJabberAddress();
        String emailAddress = user.getEmail();
        List groupNames = this.bambooUserManager.getGroupNamesAsList((User)user);
        rules.addAll(this.notificationDao.getNotificationRulesForRecipients(USER_RECIPIENT, Collections.singletonList(username)));
        if (StringUtils.isNotBlank((CharSequence)jabberAddress)) {
            rules.addAll(this.notificationDao.getNotificationRulesForRecipients(IM_RECIPIENT, Collections.singletonList(jabberAddress)));
        }
        if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
            rules.addAll(this.notificationDao.getNotificationRulesForRecipients(EMAIL_RECIPIENT, Collections.singletonList(emailAddress)));
        }
        if (groupNames != null && !groupNames.isEmpty()) {
            rules.addAll(this.notificationDao.getNotificationRulesForRecipients(GROUP_RECIPIENT, (Collection)groupNames));
        }
        this.notificationDao.getNotificationRulesForRecipientType(WATCHER_RECIPIENT).stream().filter(rule -> this.labelManager.isFavourite((ImmutablePlan)rule.getPlan(), (User)user)).forEach(rules::add);
        Collections.sort(rules);
        return rules;
    }

    public boolean isRecipientUserBase(NotificationRule notificationRule) {
        return !EMAIL_RECIPIENT.equals(notificationRule.getRecipientType()) && !IM_RECIPIENT.equals(notificationRule.getRecipientType());
    }

    public void replaceNotificationRule(@NotNull NotificationSet notificationSet, long existingNotificationId, @NotNull NotificationRule newNotificationRule) {
        notificationSet.removeNotificationRule(existingNotificationId);
        this.saveNotificationSet(notificationSet);
        notificationSet.addNotification(newNotificationRule);
        this.saveNotificationSet(notificationSet);
    }

    @NotNull
    public NotificationSet createOrGetSystemNotificationSet() {
        List<NotificationSet> systemNotificationSets = this.getNotificationSetsForType(NotificationSet.NotificationSetType.SYSTEM);
        if (systemNotificationSets.isEmpty()) {
            NotificationSetImpl notificationSet = new NotificationSetImpl(NotificationSet.NotificationSetType.SYSTEM);
            this.saveNotificationSet(notificationSet);
            return notificationSet;
        }
        return systemNotificationSets.get(0);
    }

    public void saveSystemNotificationRule(@NotNull NotificationRule notificationRule) {
        this.notificationDao.saveNotificationRule(notificationRule);
    }

    @Nullable
    public NotificationRule getNotificationRuleById(long notificationId) {
        return (NotificationRule)this.notificationDao.findById(notificationId);
    }

    private Predicate<NotificationType> notificationTypePredicate(NotificationType.Scope scope) {
        return notificationType -> scope == notificationType.getScope();
    }

    private Predicate<NotificationRule> notificationRuleScopePredicate(NotificationType.Scope scope) {
        return notificationRule -> {
            NotificationType notificationType = this.getNotificationType((NotificationRule)notificationRule);
            return notificationType != null && scope == notificationType.getScope();
        };
    }

    public void setNotificationDao(NotificationDao notificationRuleDao) {
        this.notificationDao = notificationRuleDao;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }
}

