/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="NOTIFICATION_SETS")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class NotificationSetImpl
extends BambooEntityObject
implements NotificationSet {
    private static final Logger log = Logger.getLogger(NotificationSetImpl.class);
    Set<NotificationRule> notificationRules = new HashSet<NotificationRule>();
    private NotificationSet.NotificationSetType notificationSetType;

    public NotificationSetImpl() {
    }

    public NotificationSetImpl(NotificationSet.NotificationSetType notificationSetType) {
        this.notificationSetType = notificationSetType;
    }

    public List<NotificationRule> getSortedNotificationRules() {
        return this.notificationRules.stream().sorted().collect(Collectors.toCollection(ArrayList::new));
    }

    public void addNotification(NotificationRule notificationRule) {
        notificationRule.setNotificationSet((NotificationSet)this);
        this.notificationRules.add(notificationRule);
    }

    public NotificationRule getNotificationRuleById(long id) {
        for (NotificationRule notificationRule : this.notificationRules) {
            if (notificationRule.getId() != id) continue;
            return notificationRule;
        }
        return null;
    }

    public void removeNotificationRule(long id) {
        Iterator<NotificationRule> iterator = this.notificationRules.iterator();
        while (iterator.hasNext()) {
            NotificationRule notificationRule = iterator.next();
            if (notificationRule.getId() != id) continue;
            notificationRule.setNotificationSet(null);
            iterator.remove();
        }
    }

    public void setNotificationRules(@NotNull Set<NotificationRule> notificationRules) {
        this.notificationRules = notificationRules;
    }

    @NotNull
    public Set<NotificationRule> getNotificationRules() {
        return this.notificationRules;
    }

    public NotificationSet.NotificationSetType getNotificationSetType() {
        return this.notificationSetType;
    }

    public void setNotificationSetType(NotificationSet.NotificationSetType notificationSetType) {
        this.notificationSetType = notificationSetType;
    }
}

