/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.SystemNotificationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemNotificationServiceImpl
implements SystemNotificationService {
    private static final Logger log = Logger.getLogger(SystemNotificationServiceImpl.class);
    private final ReadWriteLock systemNotificationLoc = new ReentrantReadWriteLock();
    private final NotificationManager notificationManager;

    public SystemNotificationServiceImpl(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NotificationRule doesSystemNotificationSetContainRule(@NotNull NotificationRule rule) {
        this.systemNotificationLoc.readLock().lock();
        try {
            NotificationSet notificationSet = this.notificationManager.createOrGetSystemNotificationSet();
            for (NotificationRule oldRule : notificationSet.getNotificationRules()) {
                if (!oldRule.equals(rule)) continue;
                NotificationRule notificationRule = oldRule;
                return notificationRule;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.systemNotificationLoc.readLock().unlock();
        }
    }

    public void saveSystemNotificationRule(@NotNull NotificationRule notificationRule) {
        this.systemNotificationLoc.writeLock().lock();
        try {
            NotificationSet systemNotificationSet = this.notificationManager.createOrGetSystemNotificationSet();
            notificationRule.setNotificationSet(systemNotificationSet);
            this.notificationManager.saveSystemNotificationRule(notificationRule);
        }
        finally {
            this.systemNotificationLoc.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSystemNotificationRule(long id) {
        this.systemNotificationLoc.writeLock().lock();
        try {
            NotificationSet set = this.notificationManager.createOrGetSystemNotificationSet();
            set.removeNotificationRule(id);
            this.notificationManager.saveNotificationSet(set);
        }
        finally {
            this.systemNotificationLoc.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<NotificationRule> getSystemNotificationRules() {
        this.systemNotificationLoc.readLock().lock();
        try {
            NotificationSet systemNotificationSet = this.notificationManager.createOrGetSystemNotificationSet();
            ArrayList<NotificationRule> notificationRules = new ArrayList<NotificationRule>(systemNotificationSet.getNotificationRules());
            Collections.sort(notificationRules);
            ArrayList<NotificationRule> arrayList = notificationRules;
            return arrayList;
        }
        finally {
            this.systemNotificationLoc.readLock().unlock();
        }
    }
}

