/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildcommented;

import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.comment.CommentService;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.event.BuildCommentedEvent;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.notification.ExtendedNotification;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.user.gravatar.GravatarService;
import com.atlassian.mail.Email;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class CommentNotification
extends AbstractNotification
implements ExtendedNotification {
    private static final Logger log = Logger.getLogger(CommentNotification.class);
    public static final String TEXT_EMAIL_TEMPLATE = "notification-templates/BuildCommentedTextEmail.ftl";
    public static final String HTML_EMAIL_TEMPLATE = "notification-templates/BuildCommentedHtmlEmail.ftl";
    public static final String IM_TEMPLATE = "notification-templates/BuildCommentedIm.ftl";
    private static final String HTML_IM_TEMPLATE = "notification-templates/htmlIm/BuildCommentedHtmlIm.ftl";
    private PlanManager planManager;
    private ResultsSummaryManager resultsSummaryManager;
    private TemplateRenderer templateRenderer;
    private GravatarService gravatarService;
    @Inject
    private CommentService commentService;
    @Inject
    private BranchStatusService branchStatusService;

    @NotNull
    public String getDescription() {
        return "Build Commented Notification";
    }

    @Nullable
    public String getTextEmailContent() throws Exception {
        BuildCommentedEvent event = (BuildCommentedEvent)this.getPojoEvent();
        return this.getMessageContent(event, TEXT_EMAIL_TEMPLATE, "Could not render text email content for " + this.getDescription(), "Event is null, could not create Text Email content for " + this.getDescription());
    }

    @Nullable
    public String getHtmlEmailContent() throws Exception {
        BuildCommentedEvent event = (BuildCommentedEvent)this.getPojoEvent();
        return this.getMessageContent(event, HTML_EMAIL_TEMPLATE, "Could not render html email content for " + this.getDescription(), "Event is null, could not create Html Email content for " + this.getDescription());
    }

    @Nullable
    public String getEmailSubject() throws Exception {
        BuildCommentedEvent commentEvent;
        Plan plan;
        Object event = this.getPojoEvent();
        if (event != null && (plan = this.planManager.getPlanByKey((commentEvent = (BuildCommentedEvent)event).getBuildPlanKey())) != null) {
            Comment addedComment = commentEvent.getComment();
            StringBuilder emailSubject = new StringBuilder();
            if (addedComment.getUser() != null) {
                emailSubject.append(addedComment.getUser().getFullName());
            } else if (addedComment.getUserName() != null) {
                emailSubject.append(addedComment.getUserName());
            } else {
                emailSubject.append("Anonymous User");
            }
            return emailSubject.append(" commented on ").append(plan.getName()).append(" ").append(commentEvent.getBuildNumber()).toString();
        }
        return null;
    }

    @Nullable
    public String getIMContent() {
        BuildCommentedEvent event = (BuildCommentedEvent)this.getPojoEvent();
        return this.getMessageContent(event, IM_TEMPLATE, "Could not render im content for " + this.getDescription(), "Event is null, could not create Instant Message content for " + this.getDescription());
    }

    @Nullable
    private String getMessageContent(BuildCommentedEvent commentEvent, String imTemplate, String errorMessage, String eventIsEmptyMessage) {
        if (commentEvent == null) {
            log.error((Object)eventIsEmptyMessage);
            return null;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.populateContext(commentEvent, context);
        try {
            return this.templateRenderer.render(imTemplate, context);
        }
        catch (Exception e) {
            log.error((Object)errorMessage, (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public String getHtmlImContent() {
        BuildCommentedEvent event = (BuildCommentedEvent)this.getPojoEvent();
        return this.getMessageContent(event, HTML_IM_TEMPLATE, "Could not render im content for " + this.getDescription(), "Event is null, could not create Instant Message content for " + this.getDescription());
    }

    @NotNull
    public Email updateEmail(@NotNull Email email) {
        Object event = this.getPojoEvent();
        if (event != null) {
            BuildCommentedEvent commentEvent = (BuildCommentedEvent)event;
            email.addHeader("X-Bamboo-Plan-Key", commentEvent.getBuildPlanKey());
            Comment addedComment = commentEvent.getComment();
            if (addedComment.getUser() != null) {
                email.setFromName(addedComment.getUser().getFullName());
            } else if (addedComment.getUserName() != null) {
                email.setFromName(addedComment.getUserName());
            }
        }
        return email;
    }

    private void populateContext(BuildCommentedEvent commentEvent, Map<String, Object> context) {
        Plan plan = this.planManager.getPlanByKey(commentEvent.getBuildPlanKey());
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(commentEvent.getPlanResultKey());
        List comments = resultsSummary != null ? this.commentService.getCommentsForEntity((BambooIdProvider)resultsSummary) : Collections.emptyList();
        Comment addedComment = commentEvent.getComment();
        context.put("notification", this);
        context.put("buildSummary", resultsSummary);
        context.put("build", plan);
        context.put("plan", plan);
        context.put("addedComment", addedComment);
        context.put("comments", comments);
        context.put("branchStatus", this.branchStatusService.getBranchStatusLinkInfo((ImmutablePlan)plan, "email"));
        if (this.gravatarService != null && addedComment.getUser() != null) {
            context.put("gravatarUrl", this.gravatarService.getGravatarUrl(addedComment.getUser().getEmail(), 16));
        }
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setGravatarService(GravatarService gravatarService) {
        this.gravatarService = gravatarService;
    }
}

