/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildcommented;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.event.BuildCommentedEvent;
import com.atlassian.bamboo.notification.AbstractNotificationEventListener;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.buildcommented.CommentNotification;
import com.atlassian.bamboo.notification.buildcommented.CommentNotificationType;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.event.Event;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CommentNotificationListener
extends AbstractNotificationEventListener<BuildCommentedEvent> {
    private static final Logger log = Logger.getLogger(CommentNotificationListener.class);
    private ResultsSummaryManager resultsSummaryManager;
    private NotificationFactory notificationFactory;

    public CommentNotificationListener() {
        super(BuildCommentedEvent.class, Sets.newHashSet((Object[])new Class[]{CommentNotificationType.class}));
    }

    @Override
    public void handleEvent(@NotNull BuildCommentedEvent event, @NotNull ImmutablePlan plan) {
        try {
            CommentNotification buildCommentedNotification = BambooNotificationUtils.createNotification(CommentNotification.class);
            buildCommentedNotification.setEvent(event);
            buildCommentedNotification.excludeRecipient((NotificationRecipient)this.notificationFactory.getUserRecipient(event.getComment().getUserName()));
            Job job = (Job)Narrow.to((Object)plan, Job.class);
            Iterable<NotificationRule> notificationRules = job != null ? this.getNotificationRules((ImmutablePlan)job.getParent(), event) : this.getNotificationRules(plan, event);
            for (NotificationRule rule : notificationRules) {
                log.debug((Object)("Build Commented notification rule found for " + plan.getKey() + ", recipient: " + rule.getRecipient() + ", type: " + rule.getRecipientType()));
                NotificationRecipient recipient = this.notificationManager.getNotificationRecipient(rule);
                if (recipient instanceof NotificationRecipient.RequiresPlan) {
                    ((NotificationRecipient.RequiresPlan)recipient).setPlan(plan);
                }
                if (recipient instanceof NotificationRecipient.RequiresResultSummary) {
                    ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(event.getPlanResultKey());
                    ((NotificationRecipient.RequiresResultSummary)recipient).setResultsSummary(resultsSummary);
                }
                if (recipient instanceof NotificationRecipient.RequiresEvent) {
                    ((NotificationRecipient.RequiresEvent)recipient).setEvent((Event)event);
                }
                if (recipient == null) continue;
                buildCommentedNotification.addRecipient(recipient);
            }
            this.notificationDispatcher.dispatchNotifications((Notification)buildCommentedNotification);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"Error in CommentNotificationListener.handleEvent", (Throwable)e);
        }
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setNotificationFactory(NotificationFactory notificationFactory) {
        this.notificationFactory = notificationFactory;
    }
}

