/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildcompleted;

import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.event.PlanResultEvent;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.notification.ExtendedNotification;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReasonRenderer;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.mail.Email;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCompletedNotification
extends AbstractNotification
implements ExtendedNotification {
    private static final Logger log = Logger.getLogger(AbstractCompletedNotification.class);
    protected ResultsSummary resultsSummary;
    protected ImmutablePlan plan;
    private String triggerReasonDescription;
    private String triggerReasonDescriptionHtml;
    private String triggerReasonShortDescription;
    private ResultsSummaryManager resultsSummaryManager;
    private TemplateRenderer templateRenderer;
    private TriggerManager triggerManager;
    private final BranchStatusService branchStatusService;
    private final CachedPlanManager cachedPlanManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final VcsRepositoryViewerManager vcsRepositoryViewerManager;
    private final CustomVariableContext customVariableContext;

    @Inject
    public AbstractCompletedNotification(BranchStatusService branchStatusService, CachedPlanManager cachedPlanManager, VcsRepositoryViewerManager vcsRepositoryViewerManager, RepositoryDefinitionManager repositoryDefinitionManager, CustomVariableContext customVariableContext) {
        this.branchStatusService = branchStatusService;
        this.cachedPlanManager = cachedPlanManager;
        this.vcsRepositoryViewerManager = vcsRepositoryViewerManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.customVariableContext = customVariableContext;
    }

    @NotNull
    public Email updateEmail(@NotNull Email email) {
        if (this.plan != null) {
            email.addHeader("X-Bamboo-Plan-Key", this.plan.getKey());
        }
        return email;
    }

    @NotNull
    public String getDescription() {
        return "Completed Plan Notification";
    }

    public void init() {
        Object event = this.getPojoEvent();
        if (event == null) {
            throw new IllegalArgumentException("Can not create Notification content with null event");
        }
        if (!(event instanceof PlanResultEvent)) {
            throw new IllegalArgumentException("This notification type does not support events of type: " + event.getClass());
        }
        PlanResultEvent pcEvent = (PlanResultEvent)event;
        this.resultsSummary = this.resultsSummaryManager.getResultsSummary(pcEvent.getPlanResultKey());
        if (this.resultsSummary == null) {
            throw new IllegalArgumentException("Results summary for " + pcEvent.getPlanResultKey() + " not found");
        }
        this.plan = this.cachedPlanManager.getPlanByKey(pcEvent.getPlanKey());
        TriggerReason triggerReason = this.resultsSummary.getTriggerReason();
        TriggerReasonRenderer reasonRenderer = this.triggerManager.getTriggerReasonRenderer(triggerReason, this.resultsSummary);
        this.triggerReasonDescription = reasonRenderer.getLongDescriptionText().trim();
        this.triggerReasonDescriptionHtml = reasonRenderer.getLongDescriptionHtml();
        this.triggerReasonShortDescription = reasonRenderer.getShortDescriptionText().trim();
    }

    public String getCommitUrl(@NotNull RepositoryDataEntity repositoryDataEntity, String revision) {
        return this.getCommitUrl(repositoryDataEntity, revision, this.plan, this.customVariableContext, this.repositoryDefinitionManager, this.vcsRepositoryViewerManager);
    }

    @Nullable
    public String getTextEmailContent() throws Exception {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            context.put("triggerReasonDescription", this.triggerReasonDescription);
            try {
                return this.templateRenderer.render(this.getTextEmailTemplate(), context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Text Email content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getHtmlEmailContent() throws Exception {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            context.put("triggerReasonDescription", this.triggerReasonDescriptionHtml);
            try {
                return this.templateRenderer.render(this.getHtmlEmailTemplate(), context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Email content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getIMContent() {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            context.put("triggerReasonDescription", this.triggerReasonShortDescription);
            try {
                return this.templateRenderer.render(this.getImTemplate(), context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render IM content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    @Nullable
    public String getHtmlImContent() {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            context.put("triggerReasonDescription", this.triggerReasonShortDescription);
            try {
                return this.templateRenderer.render(this.getHtmlImTemplate(), context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render IM content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getEmailSubject() {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(this.getEmailSubjectTemplate(), context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email subject", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create email subject for " + this.getDescription()));
        return null;
    }

    protected void populateContext(Map<String, Object> context) {
        context.put("notification", this);
        context.put("buildSummary", this.resultsSummary);
        context.put("build", this.plan);
        context.put("jiraIssues", Collections.emptyList());
        context.put("branchStatus", this.branchStatusService.getBranchStatusLinkInfo(this.resultsSummary.getImmutablePlan(), "email"));
    }

    protected abstract String getTextEmailTemplate();

    protected abstract String getHtmlEmailTemplate();

    protected abstract String getImTemplate();

    protected abstract String getEmailSubjectTemplate();

    protected String getHtmlImTemplate() {
        return this.getImTemplate();
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setTriggerManager(TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
    }
}

