/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildcompleted;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.container.PersisterFactory;
import com.atlassian.bamboo.event.BuildStateResultEvent;
import com.atlassian.bamboo.notification.buildcompleted.AbstractCompletedNotification;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class BuildCompletedNotification
extends AbstractCompletedNotification {
    private static final Logger log = Logger.getLogger(BuildCompletedNotification.class);
    private static final String TEXT_EMAIL_TEMPLATE = "notification-templates/BuildCompletedTextEmail.ftl";
    private static final String HTML_EMAIL_TEMPLATE = "notification-templates/BuildCompletedHtmlEmail.ftl";
    private static final String IM_TEMPLATE = "notification-templates/BuildCompletedIm.ftl";
    private static final String HTML_IM_TEMPLATE = "notification-templates/htmlIm/BuildCompletedHtmlIm.ftl";
    private static final String EMAIL_SUBJECT = "notification-templates/BuildCompletedEmailSubject.ftl";
    protected BuildResults buildResults;

    @Inject
    public BuildCompletedNotification(BranchStatusService branchStatusService, CachedPlanManager cachedPlanManager, VcsRepositoryViewerManager vcsRepositoryViewerManager, RepositoryDefinitionManager repositoryDefinitionManager, CustomVariableContext customVariableContext) {
        super(branchStatusService, cachedPlanManager, vcsRepositoryViewerManager, repositoryDefinitionManager, customVariableContext);
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Completed Builds Notification";
    }

    @Override
    public void init() {
        super.init();
        Object event = this.getPojoEvent();
        if (event != null) {
            BuildStateResultEvent buildCompletedEvent = (BuildStateResultEvent)event;
            this.buildResults = PersisterFactory.getInstance().getBuildResults((Key)buildCompletedEvent.getPlanKey(), buildCompletedEvent.getBuildNumber());
        }
    }

    @Override
    protected void populateContext(Map<String, Object> context) {
        super.populateContext(context);
        context.put("buildResults", this.buildResults);
        List buildErrors = this.buildResults.getBuildErrors();
        int logLinesToShow = SystemProperty.LOG_LINES_FOR_NOTIFICATIONS.getValue(100);
        if (buildErrors.size() > logLinesToShow) {
            context.put("shortErrorSummary", buildErrors.subList(buildErrors.size() - logLinesToShow, buildErrors.size()));
        } else {
            context.put("shortErrorSummary", buildErrors);
        }
    }

    @Override
    protected String getTextEmailTemplate() {
        return TEXT_EMAIL_TEMPLATE;
    }

    @Override
    protected String getHtmlEmailTemplate() {
        return HTML_EMAIL_TEMPLATE;
    }

    @Override
    protected String getImTemplate() {
        return IM_TEMPLATE;
    }

    @Override
    protected String getEmailSubjectTemplate() {
        return EMAIL_SUBJECT;
    }

    @Override
    protected String getHtmlImTemplate() {
        return HTML_IM_TEMPLATE;
    }
}

