/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildcompleted;

import com.atlassian.bamboo.event.BuildStateResultEvent;
import com.atlassian.bamboo.notification.AbstractNotificationEventListener;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.buildcompleted.AllBuildsNotificationType;
import com.atlassian.bamboo.notification.buildcompleted.BuildCompletedNotification;
import com.atlassian.bamboo.notification.buildcompleted.BuildFailedAndFirstFixedNotificationType;
import com.atlassian.bamboo.notification.buildcompleted.BuildStatusChangeNotificationType;
import com.atlassian.bamboo.notification.buildcompleted.FirstJobFailedNotificationType;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.event.Event;
import com.google.common.collect.Sets;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class BuildCompletedNotificationListener
extends AbstractNotificationEventListener<BuildStateResultEvent> {
    private static final Logger log = Logger.getLogger(BuildCompletedNotificationListener.class);
    private ResultsSummaryManager resultsSummaryManager;

    public BuildCompletedNotificationListener() {
        super(BuildStateResultEvent.class, Sets.newHashSet((Object[])new Class[]{AllBuildsNotificationType.class, BuildFailedAndFirstFixedNotificationType.class, BuildStatusChangeNotificationType.class, FirstJobFailedNotificationType.class}));
    }

    @Override
    public void handleEvent(@NotNull BuildStateResultEvent event, @NotNull ImmutablePlan plan) {
        BuildCompletedNotification buildCompletedNotification = BambooNotificationUtils.createNotification(BuildCompletedNotification.class);
        buildCompletedNotification.setEvent(event);
        buildCompletedNotification.init();
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(event.getPlanResultKey());
        log.debug((Object)("Completed Builds Notification Listener checking for notifications to send for " + event.getBuildResultKey()));
        for (NotificationRule rule : this.getNotificationRules(plan, event)) {
            log.debug((Object)("Completed build notification (" + rule.getConditionKey() + ") rule found for recipient: " + rule.getRecipient() + ", type: " + rule.getRecipientType()));
            NotificationRecipient recipient = this.notificationManager.getNotificationRecipient(rule);
            if (recipient instanceof NotificationRecipient.RequiresPlan) {
                ((NotificationRecipient.RequiresPlan)recipient).setPlan(plan);
            }
            if (recipient instanceof NotificationRecipient.RequiresResultSummary) {
                ((NotificationRecipient.RequiresResultSummary)recipient).setResultsSummary(resultsSummary);
            }
            if (recipient instanceof NotificationRecipient.RequiresEvent) {
                ((NotificationRecipient.RequiresEvent)recipient).setEvent((Event)event);
            }
            if (recipient == null) continue;
            buildCompletedNotification.addRecipient(recipient);
        }
        this.notificationDispatcher.dispatchNotifications((Notification)buildCompletedNotification);
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

