/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildcompleted;

import com.atlassian.bamboo.build.BuildStatusHelper;
import com.atlassian.bamboo.event.BuildCompletedEvent;
import com.atlassian.bamboo.notification.AbstractNotificationType;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildFailedAndFirstFixedNotificationType
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(BuildFailedAndFirstFixedNotificationType.class);
    private ResultsSummaryManager resultsSummaryManager;
    private PlanManager planManager;

    @Override
    public boolean isNotificationRequired(@NotNull Object event) {
        ResultsSummary resultsSummary;
        BuildCompletedEvent buildCompletedEvent = (BuildCompletedEvent)Narrow.to((Object)event, BuildCompletedEvent.class);
        if (buildCompletedEvent != null && (resultsSummary = this.resultsSummaryManager.getResultsSummary(buildCompletedEvent.getPlanResultKey())) != null) {
            Plan plan;
            if (resultsSummary.isFailed()) {
                return true;
            }
            if (resultsSummary.isSuccessful() && (plan = this.planManager.getPlanByKey(buildCompletedEvent.getPlanKey())) != null) {
                BuildStatusHelper statusHelper = new BuildStatusHelper((ImmutablePlan)plan, plan.getPlanKey(), resultsSummary, this.resultsSummaryManager);
                return statusHelper.getFixesBuild() != null;
            }
        }
        return false;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }
}

