/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildcompleted;

import com.atlassian.bamboo.event.BuildCompletedEvent;
import com.atlassian.bamboo.notification.AbstractNotificationType;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildStatusChangeNotificationType
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(BuildStatusChangeNotificationType.class);
    private ResultsSummaryManager resultsSummaryManager;

    @Override
    public boolean isNotificationRequired(@NotNull Object event) {
        ResultsSummary resultsSummary;
        BuildCompletedEvent buildCompletedEvent = (BuildCompletedEvent)Narrow.to((Object)event, BuildCompletedEvent.class);
        if (buildCompletedEvent != null && (resultsSummary = this.resultsSummaryManager.getResultsSummary(buildCompletedEvent.getPlanResultKey())) != null) {
            if (resultsSummary.isOnceOff()) {
                log.debug((Object)("Build result type " + resultsSummary.getPlanResultKey() + " is ONCE_OFF, not sending BuildStatusChange notification."));
                return false;
            }
            ResultsSummary previousResultsSummary = this.resultsSummaryManager.findLastResultBefore(buildCompletedEvent.getPlanResultKey(), resultsSummary.getClass(), false);
            if (this.buildResultStatusHasChanged(resultsSummary, previousResultsSummary)) {
                log.info((Object)("Build status changed to " + resultsSummary.getBuildState() + " sending a notification "));
                return true;
            }
        }
        return false;
    }

    private boolean buildResultStatusHasChanged(@NotNull ResultsSummary resultsSummary, @Nullable ResultsSummary previousResultsSummary) {
        return previousResultsSummary == null || resultsSummary.getBuildState() != previousResultsSummary.getBuildState();
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

