/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.builderror;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.event.BambooErrorEvent;
import com.atlassian.bamboo.logger.DecoratedErrorDetailsFactory;
import com.atlassian.bamboo.logger.DecoratedErrorDetailsImpl;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.notification.ExtendedNotification;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.mail.Email;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class BuildErrorNotification
extends AbstractNotification
implements ExtendedNotification {
    private static final Logger log = Logger.getLogger(BuildErrorNotification.class);
    public static final String TEXT_EMAIL_TEMPLATE = "notification-templates/BuildErrorTextEmail.ftl";
    public static final String HTML_EMAIL_TEMPLATE = "notification-templates/BuildErrorHtmlEmail.ftl";
    public static final String HTML_IM_TEMPLATE = "notification-templates/htmlIm/BuildErrorHtmlIm.ftl";
    public static final String IM_TEMPLATE = "notification-templates/BuildErrorIm.ftl";
    private DecoratedErrorDetailsImpl errorDetails;
    private DecoratedErrorDetailsFactory decoratedErrorDetailsFactory;
    private PlanManager planManager;
    private TemplateRenderer templateRenderer;
    @Inject
    private BranchStatusService branchStatusService;

    @NotNull
    public Email updateEmail(@NotNull Email email) {
        Key entityKey;
        BambooErrorEvent event = this.getEvent();
        if (event != null && (entityKey = event.getErrorDetails().getEntityKey()) != null) {
            email.addHeader("X-Bamboo-Plan-Key", entityKey.getKey());
        }
        return email;
    }

    @NotNull
    public String getDescription() {
        return "Build Errored Notification";
    }

    @Nullable
    public String getTextEmailContent() throws Exception {
        BambooErrorEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(TEXT_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render text email content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Text Email content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getHtmlEmailContent() throws Exception {
        BambooErrorEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(HTML_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render HTML email content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create HTML Email content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getEmailSubject() throws Exception {
        DecoratedErrorDetailsImpl errorDetails;
        BambooErrorEvent event = this.getEvent();
        if (event != null && (errorDetails = this.getErrorDetails()).getEntityKey() != null) {
            if (errorDetails.getResultNumber() != null) {
                return "Error detected for " + errorDetails.getBuildName() + " > " + errorDetails.getBuildResultKey();
            }
            return "Error detected for plan " + errorDetails.getBuildName();
        }
        return null;
    }

    @Nullable
    public String getIMContent() {
        BambooErrorEvent event = this.getEvent();
        if (this.getEvent() != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    @Nullable
    public String getHtmlImContent() {
        BambooErrorEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(HTML_IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    @Nullable
    public BambooErrorEvent getEvent() {
        return (BambooErrorEvent)((Object)Narrow.downTo((Object)this.getPojoEvent(), BambooErrorEvent.class));
    }

    @Nullable
    private DecoratedErrorDetailsImpl getErrorDetails() {
        BambooErrorEvent event;
        if (this.errorDetails == null && (event = this.getEvent()) != null) {
            this.errorDetails = this.decoratedErrorDetailsFactory.decorate(event.getErrorDetails());
        }
        return this.errorDetails;
    }

    private void populateContext(@NotNull Map<String, Object> context) {
        context.put("notification", this);
        DecoratedErrorDetailsImpl errorDetails = this.getErrorDetails();
        PlanKey planKey = (PlanKey)Narrow.downTo((Object)errorDetails.getEntityKey(), PlanKey.class);
        if (planKey != null) {
            context.put("buildKey", planKey.getKey());
            Plan plan = this.planManager.getPlanByKey(planKey);
            if (plan != null) {
                context.put("build", plan);
            }
            context.put("branchStatus", this.branchStatusService.getBranchStatusLinkInfo((ImmutablePlan)plan, "email"));
        }
        if (errorDetails.getResultNumber() != null) {
            context.put("buildNumber", errorDetails.getResultNumber());
        }
        context.put("error", errorDetails);
    }

    public void setDecoratedErrorDetailsFactory(DecoratedErrorDetailsFactory decoratedErrorDetailsFactory) {
        this.decoratedErrorDetailsFactory = decoratedErrorDetailsFactory;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }
}

