/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.builderror;

import com.atlassian.bamboo.event.BambooErrorEvent;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.notification.AbstractNotificationEventListener;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.builderror.BuildErrorNotification;
import com.atlassian.bamboo.notification.builderror.BuildErrorNotificationType;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.event.Event;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildErrorNotificationListener
extends AbstractNotificationEventListener<BambooErrorEvent> {
    private static final Logger log = Logger.getLogger(BuildErrorNotificationListener.class);
    private ResultsSummaryManager resultsSummaryManager;

    public BuildErrorNotificationListener() {
        super(BambooErrorEvent.class, Sets.newHashSet((Object[])new Class[]{BuildErrorNotificationType.class}));
    }

    @Override
    public void handleEvent(@NotNull BambooErrorEvent event, @NotNull ImmutablePlan plan) {
        BuildErrorNotification buildErrorNotification = BambooNotificationUtils.createNotification(BuildErrorNotification.class);
        buildErrorNotification.setEvent(event);
        ErrorDetails errorDetails = event.getErrorDetails();
        for (NotificationRule rule : this.getNotificationRules(plan, event)) {
            PlanResultKey planResultKey;
            log.debug((Object)("Build Error notification rule found for " + plan.getKey() + ", recipient: " + rule.getRecipient() + ", type: " + rule.getRecipientType()));
            NotificationRecipient recipient = this.notificationManager.getNotificationRecipient(rule);
            if (recipient instanceof NotificationRecipient.RequiresPlan) {
                ((NotificationRecipient.RequiresPlan)recipient).setPlan(plan);
            }
            if (recipient instanceof NotificationRecipient.RequiresResultSummary && (planResultKey = (PlanResultKey)Narrow.downTo((Object)errorDetails.getResultKey(), PlanResultKey.class)) != null) {
                ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
                ((NotificationRecipient.RequiresResultSummary)recipient).setResultsSummary(resultsSummary);
            }
            if (recipient instanceof NotificationRecipient.RequiresEvent) {
                ((NotificationRecipient.RequiresEvent)recipient).setEvent((Event)event);
            }
            if (recipient == null) continue;
            buildErrorNotification.addRecipient(recipient);
        }
        this.notificationDispatcher.dispatchNotifications((Notification)buildErrorNotification);
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

