/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.builderror;

import com.atlassian.bamboo.event.BambooErrorEvent;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.notification.AbstractNotificationType;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildErrorNotificationType
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(BuildErrorNotificationType.class);
    private static final String FIRST_ERROR_FIELD = "firstErrorOccuranceOnly";
    boolean firstOnly = true;
    private TemplateRenderer templateRenderer;

    @Override
    public void setConfigurationData(@Nullable String data) {
        if (data != null) {
            try {
                this.firstOnly = Boolean.parseBoolean(data);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Unable to parse " + data), (Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public String getConfigurationData() {
        return Boolean.toString(this.firstOnly);
    }

    @Override
    public boolean isNotificationRequired(@NotNull Object event) {
        if (event instanceof BambooErrorEvent) {
            BambooErrorEvent bambooErrorEvent = (BambooErrorEvent)((Object)event);
            ErrorDetails errorDetails = bambooErrorEvent.getErrorDetails();
            if (!errorDetails.isBuildSpecific() || errorDetails.getEntityKey() == null) {
                return false;
            }
            return bambooErrorEvent.isNewError() || !this.firstOnly;
        }
        return false;
    }

    @Override
    public void populate(@NotNull Map<String, String[]> config) {
        Object[] numArray = config.get(FIRST_ERROR_FIELD);
        this.firstOnly = numArray != null && Boolean.parseBoolean(StringUtils.join((Object[])numArray));
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull Map<String, String[]> params) {
        return new SimpleErrorCollection();
    }

    @Override
    @NotNull
    public String getEditHtml() {
        String editTemplateLocation = this.notificationTypeModuleDescriptor.getEditTemplate();
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(FIRST_ERROR_FIELD, Boolean.toString(this.firstOnly));
        return this.templateRenderer.render(editTemplateLocation, context);
    }

    @Override
    @NotNull
    public String getViewHtml() {
        if (!this.firstOnly) {
            return "Notify On All Build Errors";
        }
        return "Notify On First Occurrence of Build Errors";
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }
}

