/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildhung;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.monitoring.BuildHungDetails;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.event.BuildHungEvent;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.notification.ExtendedNotification;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.mail.Email;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class BuildHungNotification
extends AbstractNotification
implements ExtendedNotification {
    private static final Logger log = Logger.getLogger(BuildHungNotification.class);
    public static final String TEXT_EMAIL_TEMPLATE = "notification-templates/BuildHungTextEmail.ftl";
    public static final String HTML_EMAIL_TEMPLATE = "notification-templates/BuildHungHtmlEmail.ftl";
    public static final String IM_TEMPLATE = "notification-templates/BuildHungIm.ftl";
    public static final String HTML_IM_TEMPLATE = "notification-templates/htmlIm/BuildHungHtmlIm.ftl";
    private PlanManager planManager;
    private AgentManager agentManager;
    private TemplateRenderer templateRenderer;
    @Inject
    private BranchStatusService branchStatusService;

    @NotNull
    public Email updateEmail(@NotNull Email email) {
        BuildHungEvent event = this.getEvent();
        if (event != null) {
            email.addHeader("X-Bamboo-Plan-Key", event.getBuildPlanKey());
        }
        return email;
    }

    @NotNull
    public String getDescription() {
        return "Build Hung Notification";
    }

    @Nullable
    public String getTextEmailContent() throws Exception {
        BuildHungEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(TEXT_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Text Email content for " + this.getDescription()));
        return null;
    }

    private void populateContext(Map<String, Object> context, BuildHungEvent buildHungEvent) throws IllegalStateException {
        BuildAgent agent;
        CurrentlyBuilding currentlyBuilding = buildHungEvent.getCurrentlyBuilding();
        context.put("notification", this);
        context.put("buildKey", buildHungEvent.getBuildPlanKey());
        context.put("buildNumber", buildHungEvent.getBuildNumber());
        Plan plan = this.planManager.getPlanByKey(buildHungEvent.getPlanKey());
        context.put("build", plan);
        context.put("currentlyBuilding", currentlyBuilding);
        Long agentId = currentlyBuilding.getBuildAgentId();
        if (agentId != null && (agent = this.agentManager.getAgent(agentId.longValue())) != null) {
            context.put("buildAgent", agent);
        }
        context.put("commits", currentlyBuilding.getBuildChanges().getChanges());
        context.put("durationUtils", DurationUtils.getInstance());
        BuildHungDetails hungDetails = currentlyBuilding.getBuildHangDetails();
        if (hungDetails == null) {
            throw new IllegalStateException("Build hung event has been fired but build hang details is null");
        }
        context.put("excessRunningTime", currentlyBuilding.getElapsedTime() - hungDetails.getExpectedBuildTime());
        List<LogEntry> buildLogs = buildHungEvent.getBuildLogs();
        if (buildLogs != null) {
            int logLinesToShow = SystemProperty.LOG_LINES_FOR_NOTIFICATIONS.getValue(100);
            List<LogEntry> lastLogs = buildLogs.size() > logLinesToShow ? buildLogs.subList(buildLogs.size() - logLinesToShow, buildLogs.size()) : buildLogs;
            context.put("lastLogs", lastLogs);
        }
        context.put("branchStatus", this.branchStatusService.getBranchStatusLinkInfo((ImmutablePlan)plan, "email"));
    }

    @Nullable
    public String getHtmlEmailContent() throws Exception {
        BuildHungEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(HTML_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Html Email content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getEmailSubject() throws Exception {
        BuildHungEvent event = this.getEvent();
        if (event != null) {
            return event.getCurrentlyBuilding().getBuildIdentifier().getPlanName() + " " + event.getBuildNumber() + " may have hung.";
        }
        return null;
    }

    @Nullable
    public String getIMContent() {
        BuildHungEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    @Nullable
    public String getHtmlImContent() {
        BuildHungEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(HTML_IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    public BuildHungEvent getEvent() {
        return (BuildHungEvent)Narrow.downTo((Object)super.getPojoEvent(), BuildHungEvent.class);
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }
}

