/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildhung;

import com.atlassian.bamboo.event.BuildHungEvent;
import com.atlassian.bamboo.notification.AbstractNotificationEventListener;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.buildhung.BuildHungNotification;
import com.atlassian.bamboo.notification.buildhung.BuildHungNotificationType;
import com.atlassian.bamboo.notification.recipients.CommitterRecipient;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.event.Event;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildHungNotificationListener
extends AbstractNotificationEventListener<BuildHungEvent> {
    private static final Logger log = Logger.getLogger(BuildHungNotificationListener.class);

    public BuildHungNotificationListener() {
        super(BuildHungEvent.class, Collections.singleton(BuildHungNotificationType.class));
    }

    @Override
    public void handleEvent(@NotNull BuildHungEvent event, @NotNull ImmutablePlan plan) {
        BuildHungNotification buildHungNotification = BambooNotificationUtils.createNotification(BuildHungNotification.class);
        buildHungNotification.setEvent(event);
        for (NotificationRule rule : Iterables.concat(this.getNotificationRules(plan, event), this.getSystemNotificationRules(event))) {
            log.debug((Object)("Build Hung notification rule found for " + plan.getKey() + ", recipient: " + rule.getRecipient() + ", type: " + rule.getRecipientType()));
            NotificationRecipient recipient = this.notificationManager.getNotificationRecipient(rule);
            if (recipient instanceof NotificationRecipient.RequiresPlan) {
                ((NotificationRecipient.RequiresPlan)recipient).setPlan(plan);
            }
            if (recipient instanceof NotificationRecipient.RequiresEvent) {
                ((NotificationRecipient.RequiresEvent)recipient).setEvent((Event)event);
            }
            if (recipient instanceof CommitterRecipient) {
                CommitterRecipient committer = (CommitterRecipient)recipient;
                committer.setCommits(new HashSet(event.getCurrentlyBuilding().getBuildChanges().getChanges()));
            }
            if (recipient == null) continue;
            buildHungNotification.addRecipient(recipient);
        }
        this.notificationDispatcher.dispatchNotifications((Notification)buildHungNotification);
    }
}

