/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildmissingcapableagent;

import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.notification.ExtendedNotification;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.events.BuildQueuedEvent;
import com.atlassian.mail.Email;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildMissingCapableAgentNotification
extends AbstractNotification
implements ExtendedNotification {
    private static final Logger log = Logger.getLogger(BuildMissingCapableAgentNotification.class);
    public static final String TEXT_EMAIL_TEMPLATE = "notification-templates/BuildMissingCapableAgentTextEmail.ftl";
    public static final String HTML_EMAIL_TEMPLATE = "notification-templates/BuildMissingCapableAgentHtmlEmail.ftl";
    public static final String IM_TEMPLATE = "notification-templates/BuildMissingCapableAgentIm.ftl";
    public static final String HTML_IM_TEMPLATE = "notification-templates/htmlIm/BuildMissingCapableAgentHtmlIm.ftl";
    private PlanManager planManager;
    private TemplateRenderer templateRenderer;
    @Inject
    private BranchStatusService branchStatusService;

    @NotNull
    public Email updateEmail(@NotNull Email email) {
        BuildQueuedEvent event = this.getEvent();
        if (event != null) {
            email.addHeader("X-Bamboo-Plan-Key", event.getBuildContext().getPlanKey());
        }
        return email;
    }

    @NotNull
    public String getDescription() {
        return "Build Missing Capable Agent Notification";
    }

    public String getEmailSubject() throws Exception {
        BuildQueuedEvent event = this.getEvent();
        if (event != null) {
            return "No agents to build plan " + event.getBuildContext().getPlanName();
        }
        return "";
    }

    public String getHtmlEmailContent() throws Exception {
        BuildQueuedEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(HTML_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Html Email content for " + this.getDescription()));
        return null;
    }

    public String getIMContent() {
        BuildQueuedEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    public String getHtmlImContent() {
        BuildQueuedEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(HTML_IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    public String getTextEmailContent() throws Exception {
        BuildQueuedEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(TEXT_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Text Email content for " + this.getDescription()));
        return null;
    }

    @Override
    public BuildQueuedEvent getEvent() {
        return (BuildQueuedEvent)Narrow.downTo((Object)super.getPojoEvent(), BuildQueuedEvent.class);
    }

    private void populateContext(Map<String, Object> context, BuildQueuedEvent event) throws IllegalStateException {
        BuildContext buildContext = event.getBuildContext();
        context.put("notification", this);
        Plan plan = this.planManager.getPlanByKey(PlanKeys.getPlanKey((String)buildContext.getTypedPlanKey().getKey()));
        context.put("build", plan);
        context.put("buildKey", buildContext.getTypedPlanKey().getKey());
        context.put("buildNumber", buildContext.getBuildNumber());
        context.put("commits", buildContext.getBuildChanges().getChanges());
        context.put("branchStatus", this.branchStatusService.getBranchStatusLinkInfo((ImmutablePlan)plan, "email"));
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }
}

