/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildmissingcapableagent;

import com.atlassian.bamboo.notification.AbstractNotificationEventListener;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.buildmissingcapableagent.BuildMissingCapableAgentNotification;
import com.atlassian.bamboo.notification.buildmissingcapableagent.BuildMissingCapableAgentNotificationType;
import com.atlassian.bamboo.notification.recipients.CommitterRecipient;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.bamboo.v2.build.events.BuildQueuedEvent;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.event.Event;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildMissingCapableAgentNotificationListener
extends AbstractNotificationEventListener<BuildQueuedEvent> {
    private static final Logger log = Logger.getLogger(BuildMissingCapableAgentNotificationListener.class);
    @Inject
    private BuildQueueManager buildQueueManager;

    public BuildMissingCapableAgentNotificationListener() {
        super(BuildQueuedEvent.class, Collections.singleton(BuildMissingCapableAgentNotificationType.class));
    }

    @Override
    public void handleEvent(@NotNull BuildQueuedEvent event, @NotNull ImmutablePlan plan) {
        BuildMissingCapableAgentNotification notification = BambooNotificationUtils.createNotification(BuildMissingCapableAgentNotification.class);
        notification.setEvent(event);
        Set executors = this.buildQueueManager.getExecutorsForQueuedExecutable(event.getResultKey());
        if (executors == null || !executors.isEmpty()) {
            return;
        }
        for (NotificationRule rule : Iterables.concat(this.getNotificationRules(plan, event), this.getSystemNotificationRules(event))) {
            log.debug((Object)("Build Queued with no agents rule found for recipient: " + rule.getRecipient() + ", type: " + rule.getRecipientType()));
            NotificationRecipient recipient = this.notificationManager.getNotificationRecipient(rule);
            if (recipient instanceof NotificationRecipient.RequiresPlan) {
                ((NotificationRecipient.RequiresPlan)recipient).setPlan(plan);
            }
            if (recipient instanceof NotificationRecipient.RequiresEvent) {
                ((NotificationRecipient.RequiresEvent)recipient).setEvent((Event)event);
            }
            if (recipient instanceof CommitterRecipient) {
                CommitterRecipient committer = (CommitterRecipient)recipient;
                committer.setCommits(new HashSet(event.getContext().getBuildChanges().getChanges()));
            }
            if (recipient == null) continue;
            notification.addRecipient(recipient);
        }
        this.notificationDispatcher.dispatchNotifications((Notification)notification);
    }
}

