/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildqueuetimeout;

import com.atlassian.bamboo.build.monitoring.BuildQueueTimeoutDetails;
import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.event.BuildQueueTimeoutEvent;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.notification.ExtendedNotification;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.mail.Email;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildQueueTimeoutNotification
extends AbstractNotification
implements ExtendedNotification {
    private static final Logger log = Logger.getLogger(BuildQueueTimeoutNotification.class);
    public static final String TEXT_EMAIL_TEMPLATE = "notification-templates/BuildQueueTimeoutTextEmail.ftl";
    public static final String HTML_EMAIL_TEMPLATE = "notification-templates/BuildQueueTimeoutHtmlEmail.ftl";
    public static final String IM_TEMPLATE = "notification-templates/BuildQueueTimeoutIm.ftl";
    public static final String HTML_IM_TEMPLATE = "notification-templates/htmlIm/BuildQueueTimeoutHtmlIm.ftl";
    private PlanManager planManager;
    private TemplateRenderer templateRenderer;
    @Inject
    private BranchStatusService branchStatusService;

    @NotNull
    public Email updateEmail(@NotNull Email email) {
        BuildQueueTimeoutEvent event = this.getEvent();
        if (event != null) {
            email.addHeader("X-Bamboo-Plan-Key", event.getBuildPlanKey());
        }
        return email;
    }

    @NotNull
    public String getDescription() {
        return "Build Queue Timeout Notification";
    }

    @Nullable
    public String getTextEmailContent() throws Exception {
        BuildQueueTimeoutEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(TEXT_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Text Email content for " + this.getDescription()));
        return null;
    }

    private void populateContext(Map<String, Object> context, BuildQueueTimeoutEvent buildQueueTimeoutEvent) throws IllegalStateException {
        CurrentlyBuilding currentlyBuilding = buildQueueTimeoutEvent.getCurrentlyBuilding();
        BuildQueueTimeoutDetails buildQueueTimeoutDetails = currentlyBuilding.getBuildQueueTimeoutDetails();
        context.put("notification", this);
        context.put("buildKey", buildQueueTimeoutEvent.getBuildPlanKey());
        context.put("buildNumber", buildQueueTimeoutEvent.getBuildNumber());
        Plan plan = this.planManager.getPlanByKey(buildQueueTimeoutEvent.getPlanKey());
        context.put("build", plan);
        context.put("currentlyBuilding", currentlyBuilding);
        context.put("timeout", buildQueueTimeoutDetails.getQueueTimeoutMinutes());
        context.put("commits", currentlyBuilding.getBuildChanges().getChanges());
        context.put("branchStatus", this.branchStatusService.getBranchStatusLinkInfo((ImmutablePlan)plan, "email"));
    }

    @Nullable
    public String getHtmlEmailContent() throws Exception {
        BuildQueueTimeoutEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(HTML_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Html Email content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getEmailSubject() throws Exception {
        BuildQueueTimeoutEvent event = this.getEvent();
        if (event != null) {
            CurrentlyBuilding currentlyBuilding = event.getCurrentlyBuilding();
            return "Build queue timeout ( " + currentlyBuilding.getBuildQueueTimeoutDetails().getQueueTimeoutMinutes() + " minutes) has been exceeded for " + currentlyBuilding.getBuildIdentifier().getBuildResultKey() + ".";
        }
        return null;
    }

    @Nullable
    public String getIMContent() {
        BuildQueueTimeoutEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    @Nullable
    public String getHtmlImContent() {
        BuildQueueTimeoutEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context, event);
            try {
                return this.templateRenderer.render(HTML_IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    public BuildQueueTimeoutEvent getEvent() {
        return (BuildQueueTimeoutEvent)Narrow.downTo((Object)super.getPojoEvent(), BuildQueueTimeoutEvent.class);
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }
}

