/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.buildqueuetimeout;

import com.atlassian.bamboo.build.monitoring.BuildQueueTimeoutDetails;
import com.atlassian.bamboo.event.BuildQueueTimeoutEvent;
import com.atlassian.bamboo.notification.AbstractNotificationEventListener;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.buildqueuetimeout.BuildQueueTimeoutNotification;
import com.atlassian.bamboo.notification.buildqueuetimeout.BuildQueueTimeoutNotificationType;
import com.atlassian.bamboo.notification.recipients.CommitterRecipient;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.event.Event;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildQueueTimeoutNotificationListener
extends AbstractNotificationEventListener<BuildQueueTimeoutEvent> {
    private static final Logger log = Logger.getLogger(BuildQueueTimeoutNotificationListener.class);

    public BuildQueueTimeoutNotificationListener() {
        super(BuildQueueTimeoutEvent.class, Sets.newHashSet((Object[])new Class[]{BuildQueueTimeoutNotificationType.class}));
    }

    @Override
    public void handleEvent(@NotNull BuildQueueTimeoutEvent event, @NotNull ImmutablePlan plan) {
        BuildQueueTimeoutNotification buildQueueTimeoutNotification = BambooNotificationUtils.createNotification(BuildQueueTimeoutNotification.class);
        buildQueueTimeoutNotification.setEvent(event);
        BuildQueueTimeoutDetails timeoutDetails = event.getCurrentlyBuilding().getBuildQueueTimeoutDetails();
        if (timeoutDetails == null) {
            log.warn((Object)String.format("Build queue timeout is missing in an event for '%s'.", event.getPlanResultKey()));
            return;
        }
        log.warn((Object)String.format("Build queue timeout (%d minutes) has been exceeded for '%s'.", timeoutDetails.getQueueTimeoutMinutes(), event.getPlanResultKey()));
        for (NotificationRule rule : Iterables.concat(this.getNotificationRules(plan, event), this.getSystemNotificationRules(event))) {
            log.debug((Object)("Build Queue Timeout notification rule found for " + plan.getKey() + ", recipient: " + rule.getRecipient() + ", type: " + rule.getRecipientType()));
            NotificationRecipient recipient = this.notificationManager.getNotificationRecipient(rule);
            if (recipient instanceof NotificationRecipient.RequiresPlan) {
                ((NotificationRecipient.RequiresPlan)recipient).setPlan(plan);
            }
            if (recipient instanceof NotificationRecipient.RequiresEvent) {
                ((NotificationRecipient.RequiresEvent)recipient).setEvent((Event)event);
            }
            if (recipient instanceof CommitterRecipient) {
                CommitterRecipient committer = (CommitterRecipient)recipient;
                committer.setCommits(Sets.newHashSet((Iterable)event.getCurrentlyBuilding().getBuildChanges().getChanges()));
            }
            if (recipient == null) continue;
            buildQueueTimeoutNotification.addRecipient(recipient);
        }
        this.notificationDispatcher.dispatchNotifications((Notification)buildQueueTimeoutNotification);
    }
}

